package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Lookup092301;
import com.xforceplus.huigui150.service.ILookup092301Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * lookup092301前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Lookup092301Controller {

  @Autowired
  private ILookup092301Service lookup092301ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup092301 lookup092301
   * @return
   */
  @GetMapping("/lookup092301s" )
  public XfR getLookup092301s(XfPage page, Lookup092301 lookup092301) {
    return XfR.ok(lookup092301ServiceImpl.page(page, Wrappers.query(lookup092301)));
  }

  /**
   * 通过id查询lookup092301
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup092301s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup092301ServiceImpl.getById(id));
  }

  /**
   * 新增lookup092301
   * @param lookup092301 lookup092301
   * @return XfR
   */
  @PostMapping("/lookup092301s")
  public XfR save(@RequestBody Lookup092301 lookup092301) {
     return XfR.ok(lookup092301ServiceImpl.save(lookup092301));
  }

  /**
   * 修改-传入修改后的全部数据lookup092301
   * @param lookup092301 lookup092301
   * @return XfR
   */
  @PutMapping("/lookup092301s/{id}")
  public XfR putUpdate(@RequestBody Lookup092301 lookup092301,@PathVariable Long id) {
      lookup092301.setId(id);
      return XfR.ok(lookup092301ServiceImpl.updateById(lookup092301));
  }

  /**
   * 修改-传入修改的数据lookup092301
   * @param lookup092301 lookup092301
   * @return XfR
   */
  @PatchMapping("/lookup092301s/{id}")
  public XfR patchUpdate(@RequestBody Lookup092301 lookup092301,@PathVariable Long id) {
      Lookup092301 uplookup092301 = lookup092301ServiceImpl.getById(id);
      if(uplookup092301 != null){
        uplookup092301 = ObjectCopyUtils.copyProperties(lookup092301,uplookup092301,true);
      }
      return XfR.ok(lookup092301ServiceImpl.updateById(uplookup092301));
  }

  /**
   * 通过id删除lookup092301
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup092301s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup092301ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup092301s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup092301");
     params.put("request", condition);

     return XfR.ok(lookup092301ServiceImpl.querys(params));
  }

}
