package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Test081901;
import com.xforceplus.huigui150.service.ITest081901Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test081901前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Test081901Controller {

  @Autowired
  private ITest081901Service test081901ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test081901 test081901
   * @return
   */
  @GetMapping("/test081901s" )
  public XfR getTest081901s(XfPage page, Test081901 test081901) {
    return XfR.ok(test081901ServiceImpl.page(page, Wrappers.query(test081901)));
  }

  /**
   * 通过id查询test081901
   * @param  id
   * @return XfR
   */
  @GetMapping("/test081901s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test081901ServiceImpl.getById(id));
  }

  /**
   * 新增test081901
   * @param test081901 test081901
   * @return XfR
   */
  @PostMapping("/test081901s")
  public XfR save(@RequestBody Test081901 test081901) {
     return XfR.ok(test081901ServiceImpl.save(test081901));
  }

  /**
   * 修改-传入修改后的全部数据test081901
   * @param test081901 test081901
   * @return XfR
   */
  @PutMapping("/test081901s/{id}")
  public XfR putUpdate(@RequestBody Test081901 test081901,@PathVariable Long id) {
      test081901.setId(id);
      return XfR.ok(test081901ServiceImpl.updateById(test081901));
  }

  /**
   * 修改-传入修改的数据test081901
   * @param test081901 test081901
   * @return XfR
   */
  @PatchMapping("/test081901s/{id}")
  public XfR patchUpdate(@RequestBody Test081901 test081901,@PathVariable Long id) {
      Test081901 uptest081901 = test081901ServiceImpl.getById(id);
      if(uptest081901 != null){
        uptest081901 = ObjectCopyUtils.copyProperties(test081901,uptest081901,true);
      }
      return XfR.ok(test081901ServiceImpl.updateById(uptest081901));
  }

  /**
   * 通过id删除test081901
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test081901s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test081901ServiceImpl.removeById(id));
  }

  @PostMapping("/test081901s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test081901");
     params.put("request", condition);

     return XfR.ok(test081901ServiceImpl.querys(params));
  }

}
