package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Test081902;
import com.xforceplus.huigui150.service.ITest081902Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test081902前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Test081902Controller {

  @Autowired
  private ITest081902Service test081902ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test081902 test081902
   * @return
   */
  @GetMapping("/test081902s" )
  public XfR getTest081902s(XfPage page, Test081902 test081902) {
    return XfR.ok(test081902ServiceImpl.page(page, Wrappers.query(test081902)));
  }

  /**
   * 通过id查询test081902
   * @param  id
   * @return XfR
   */
  @GetMapping("/test081902s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test081902ServiceImpl.getById(id));
  }

  /**
   * 新增test081902
   * @param test081902 test081902
   * @return XfR
   */
  @PostMapping("/test081902s")
  public XfR save(@RequestBody Test081902 test081902) {
     return XfR.ok(test081902ServiceImpl.save(test081902));
  }

  /**
   * 修改-传入修改后的全部数据test081902
   * @param test081902 test081902
   * @return XfR
   */
  @PutMapping("/test081902s/{id}")
  public XfR putUpdate(@RequestBody Test081902 test081902,@PathVariable Long id) {
      test081902.setId(id);
      return XfR.ok(test081902ServiceImpl.updateById(test081902));
  }

  /**
   * 修改-传入修改的数据test081902
   * @param test081902 test081902
   * @return XfR
   */
  @PatchMapping("/test081902s/{id}")
  public XfR patchUpdate(@RequestBody Test081902 test081902,@PathVariable Long id) {
      Test081902 uptest081902 = test081902ServiceImpl.getById(id);
      if(uptest081902 != null){
        uptest081902 = ObjectCopyUtils.copyProperties(test081902,uptest081902,true);
      }
      return XfR.ok(test081902ServiceImpl.updateById(uptest081902));
  }

  /**
   * 通过id删除test081902
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test081902s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test081902ServiceImpl.removeById(id));
  }

  @PostMapping("/test081902s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test081902");
     params.put("request", condition);

     return XfR.ok(test081902ServiceImpl.querys(params));
  }

}
