package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Test081903;
import com.xforceplus.huigui150.service.ITest081903Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test081903前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Test081903Controller {

  @Autowired
  private ITest081903Service test081903ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test081903 test081903
   * @return
   */
  @GetMapping("/test081903s" )
  public XfR getTest081903s(XfPage page, Test081903 test081903) {
    return XfR.ok(test081903ServiceImpl.page(page, Wrappers.query(test081903)));
  }

  /**
   * 通过id查询test081903
   * @param  id
   * @return XfR
   */
  @GetMapping("/test081903s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test081903ServiceImpl.getById(id));
  }

  /**
   * 新增test081903
   * @param test081903 test081903
   * @return XfR
   */
  @PostMapping("/test081903s")
  public XfR save(@RequestBody Test081903 test081903) {
     return XfR.ok(test081903ServiceImpl.save(test081903));
  }

  /**
   * 修改-传入修改后的全部数据test081903
   * @param test081903 test081903
   * @return XfR
   */
  @PutMapping("/test081903s/{id}")
  public XfR putUpdate(@RequestBody Test081903 test081903,@PathVariable Long id) {
      test081903.setId(id);
      return XfR.ok(test081903ServiceImpl.updateById(test081903));
  }

  /**
   * 修改-传入修改的数据test081903
   * @param test081903 test081903
   * @return XfR
   */
  @PatchMapping("/test081903s/{id}")
  public XfR patchUpdate(@RequestBody Test081903 test081903,@PathVariable Long id) {
      Test081903 uptest081903 = test081903ServiceImpl.getById(id);
      if(uptest081903 != null){
        uptest081903 = ObjectCopyUtils.copyProperties(test081903,uptest081903,true);
      }
      return XfR.ok(test081903ServiceImpl.updateById(uptest081903));
  }

  /**
   * 通过id删除test081903
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test081903s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test081903ServiceImpl.removeById(id));
  }

  @PostMapping("/test081903s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test081903");
     params.put("request", condition);

     return XfR.ok(test081903ServiceImpl.querys(params));
  }

}
