package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Test12345;
import com.xforceplus.huigui150.service.ITest12345Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test12345前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Test12345Controller {

  @Autowired
  private ITest12345Service test12345ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test12345 test12345
   * @return
   */
  @GetMapping("/test12345s" )
  public XfR getTest12345s(XfPage page, Test12345 test12345) {
    return XfR.ok(test12345ServiceImpl.page(page, Wrappers.query(test12345)));
  }

  /**
   * 通过id查询test12345
   * @param  id
   * @return XfR
   */
  @GetMapping("/test12345s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test12345ServiceImpl.getById(id));
  }

  /**
   * 新增test12345
   * @param test12345 test12345
   * @return XfR
   */
  @PostMapping("/test12345s")
  public XfR save(@RequestBody Test12345 test12345) {
     return XfR.ok(test12345ServiceImpl.save(test12345));
  }

  /**
   * 修改-传入修改后的全部数据test12345
   * @param test12345 test12345
   * @return XfR
   */
  @PutMapping("/test12345s/{id}")
  public XfR putUpdate(@RequestBody Test12345 test12345,@PathVariable Long id) {
      test12345.setId(id);
      return XfR.ok(test12345ServiceImpl.updateById(test12345));
  }

  /**
   * 修改-传入修改的数据test12345
   * @param test12345 test12345
   * @return XfR
   */
  @PatchMapping("/test12345s/{id}")
  public XfR patchUpdate(@RequestBody Test12345 test12345,@PathVariable Long id) {
      Test12345 uptest12345 = test12345ServiceImpl.getById(id);
      if(uptest12345 != null){
        uptest12345 = ObjectCopyUtils.copyProperties(test12345,uptest12345,true);
      }
      return XfR.ok(test12345ServiceImpl.updateById(uptest12345));
  }

  /**
   * 通过id删除test12345
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test12345s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test12345ServiceImpl.removeById(id));
  }

  @PostMapping("/test12345s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test12345");
     params.put("request", condition);

     return XfR.ok(test12345ServiceImpl.querys(params));
  }

}
