package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testbez;
import com.xforceplus.huigui150.service.ITestbezService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testbez前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class TestbezController {

  @Autowired
  private ITestbezService testbezServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testbez testbez
   * @return
   */
  @GetMapping("/testbezs" )
  public XfR getTestbezs(XfPage page, Testbez testbez) {
    return XfR.ok(testbezServiceImpl.page(page, Wrappers.query(testbez)));
  }

  /**
   * 通过id查询testbez
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbezs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testbezServiceImpl.getById(id));
  }

  /**
   * 新增testbez
   * @param testbez testbez
   * @return XfR
   */
  @PostMapping("/testbezs")
  public XfR save(@RequestBody Testbez testbez) {
     return XfR.ok(testbezServiceImpl.save(testbez));
  }

  /**
   * 修改-传入修改后的全部数据testbez
   * @param testbez testbez
   * @return XfR
   */
  @PutMapping("/testbezs/{id}")
  public XfR putUpdate(@RequestBody Testbez testbez,@PathVariable Long id) {
      testbez.setId(id);
      return XfR.ok(testbezServiceImpl.updateById(testbez));
  }

  /**
   * 修改-传入修改的数据testbez
   * @param testbez testbez
   * @return XfR
   */
  @PatchMapping("/testbezs/{id}")
  public XfR patchUpdate(@RequestBody Testbez testbez,@PathVariable Long id) {
      Testbez uptestbez = testbezServiceImpl.getById(id);
      if(uptestbez != null){
        uptestbez = ObjectCopyUtils.copyProperties(testbez,uptestbez,true);
      }
      return XfR.ok(testbezServiceImpl.updateById(uptestbez));
  }

  /**
   * 通过id删除testbez
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbezs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testbezServiceImpl.removeById(id));
  }

  @PostMapping("/testbezs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testbez");
     params.put("request", condition);

     return XfR.ok(testbezServiceImpl.querys(params));
  }

}
