package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testcszbh;
import com.xforceplus.huigui150.service.ITestcszbhService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testcszbh前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class TestcszbhController {

  @Autowired
  private ITestcszbhService testcszbhServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testcszbh testcszbh
   * @return
   */
  @GetMapping("/testcszbhs" )
  public XfR getTestcszbhs(XfPage page, Testcszbh testcszbh) {
    return XfR.ok(testcszbhServiceImpl.page(page, Wrappers.query(testcszbh)));
  }

  /**
   * 通过id查询testcszbh
   * @param  id
   * @return XfR
   */
  @GetMapping("/testcszbhs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testcszbhServiceImpl.getById(id));
  }

  /**
   * 新增testcszbh
   * @param testcszbh testcszbh
   * @return XfR
   */
  @PostMapping("/testcszbhs")
  public XfR save(@RequestBody Testcszbh testcszbh) {
     return XfR.ok(testcszbhServiceImpl.save(testcszbh));
  }

  /**
   * 修改-传入修改后的全部数据testcszbh
   * @param testcszbh testcszbh
   * @return XfR
   */
  @PutMapping("/testcszbhs/{id}")
  public XfR putUpdate(@RequestBody Testcszbh testcszbh,@PathVariable Long id) {
      testcszbh.setId(id);
      return XfR.ok(testcszbhServiceImpl.updateById(testcszbh));
  }

  /**
   * 修改-传入修改的数据testcszbh
   * @param testcszbh testcszbh
   * @return XfR
   */
  @PatchMapping("/testcszbhs/{id}")
  public XfR patchUpdate(@RequestBody Testcszbh testcszbh,@PathVariable Long id) {
      Testcszbh uptestcszbh = testcszbhServiceImpl.getById(id);
      if(uptestcszbh != null){
        uptestcszbh = ObjectCopyUtils.copyProperties(testcszbh,uptestcszbh,true);
      }
      return XfR.ok(testcszbhServiceImpl.updateById(uptestcszbh));
  }

  /**
   * 通过id删除testcszbh
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testcszbhs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testcszbhServiceImpl.removeById(id));
  }

  @PostMapping("/testcszbhs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testcszbh");
     params.put("request", condition);

     return XfR.ok(testcszbhServiceImpl.querys(params));
  }

}
