package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testduozhiguanxi;
import com.xforceplus.huigui150.service.ITestduozhiguanxiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testduozhiguanxi前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class TestduozhiguanxiController {

  @Autowired
  private ITestduozhiguanxiService testduozhiguanxiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testduozhiguanxi testduozhiguanxi
   * @return
   */
  @GetMapping("/testduozhiguanxis" )
  public XfR getTestduozhiguanxis(XfPage page, Testduozhiguanxi testduozhiguanxi) {
    return XfR.ok(testduozhiguanxiServiceImpl.page(page, Wrappers.query(testduozhiguanxi)));
  }

  /**
   * 通过id查询testduozhiguanxi
   * @param  id
   * @return XfR
   */
  @GetMapping("/testduozhiguanxis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testduozhiguanxiServiceImpl.getById(id));
  }

  /**
   * 新增testduozhiguanxi
   * @param testduozhiguanxi testduozhiguanxi
   * @return XfR
   */
  @PostMapping("/testduozhiguanxis")
  public XfR save(@RequestBody Testduozhiguanxi testduozhiguanxi) {
     return XfR.ok(testduozhiguanxiServiceImpl.save(testduozhiguanxi));
  }

  /**
   * 修改-传入修改后的全部数据testduozhiguanxi
   * @param testduozhiguanxi testduozhiguanxi
   * @return XfR
   */
  @PutMapping("/testduozhiguanxis/{id}")
  public XfR putUpdate(@RequestBody Testduozhiguanxi testduozhiguanxi,@PathVariable Long id) {
      testduozhiguanxi.setId(id);
      return XfR.ok(testduozhiguanxiServiceImpl.updateById(testduozhiguanxi));
  }

  /**
   * 修改-传入修改的数据testduozhiguanxi
   * @param testduozhiguanxi testduozhiguanxi
   * @return XfR
   */
  @PatchMapping("/testduozhiguanxis/{id}")
  public XfR patchUpdate(@RequestBody Testduozhiguanxi testduozhiguanxi,@PathVariable Long id) {
      Testduozhiguanxi uptestduozhiguanxi = testduozhiguanxiServiceImpl.getById(id);
      if(uptestduozhiguanxi != null){
        uptestduozhiguanxi = ObjectCopyUtils.copyProperties(testduozhiguanxi,uptestduozhiguanxi,true);
      }
      return XfR.ok(testduozhiguanxiServiceImpl.updateById(uptestduozhiguanxi));
  }

  /**
   * 通过id删除testduozhiguanxi
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testduozhiguanxis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testduozhiguanxiServiceImpl.removeById(id));
  }

  @PostMapping("/testduozhiguanxis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testduozhiguanxi");
     params.put("request", condition);

     return XfR.ok(testduozhiguanxiServiceImpl.querys(params));
  }

}
