package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testduozhimjx;
import com.xforceplus.huigui150.service.ITestduozhimjxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testduozhimjx前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class TestduozhimjxController {

  @Autowired
  private ITestduozhimjxService testduozhimjxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testduozhimjx testduozhimjx
   * @return
   */
  @GetMapping("/testduozhimjxs" )
  public XfR getTestduozhimjxs(XfPage page, Testduozhimjx testduozhimjx) {
    return XfR.ok(testduozhimjxServiceImpl.page(page, Wrappers.query(testduozhimjx)));
  }

  /**
   * 通过id查询testduozhimjx
   * @param  id
   * @return XfR
   */
  @GetMapping("/testduozhimjxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testduozhimjxServiceImpl.getById(id));
  }

  /**
   * 新增testduozhimjx
   * @param testduozhimjx testduozhimjx
   * @return XfR
   */
  @PostMapping("/testduozhimjxs")
  public XfR save(@RequestBody Testduozhimjx testduozhimjx) {
     return XfR.ok(testduozhimjxServiceImpl.save(testduozhimjx));
  }

  /**
   * 修改-传入修改后的全部数据testduozhimjx
   * @param testduozhimjx testduozhimjx
   * @return XfR
   */
  @PutMapping("/testduozhimjxs/{id}")
  public XfR putUpdate(@RequestBody Testduozhimjx testduozhimjx,@PathVariable Long id) {
      testduozhimjx.setId(id);
      return XfR.ok(testduozhimjxServiceImpl.updateById(testduozhimjx));
  }

  /**
   * 修改-传入修改的数据testduozhimjx
   * @param testduozhimjx testduozhimjx
   * @return XfR
   */
  @PatchMapping("/testduozhimjxs/{id}")
  public XfR patchUpdate(@RequestBody Testduozhimjx testduozhimjx,@PathVariable Long id) {
      Testduozhimjx uptestduozhimjx = testduozhimjxServiceImpl.getById(id);
      if(uptestduozhimjx != null){
        uptestduozhimjx = ObjectCopyUtils.copyProperties(testduozhimjx,uptestduozhimjx,true);
      }
      return XfR.ok(testduozhimjxServiceImpl.updateById(uptestduozhimjx));
  }

  /**
   * 通过id删除testduozhimjx
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testduozhimjxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testduozhimjxServiceImpl.removeById(id));
  }

  @PostMapping("/testduozhimjxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testduozhimjx");
     params.put("request", condition);

     return XfR.ok(testduozhimjxServiceImpl.querys(params));
  }

}
