package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testmjx;
import com.xforceplus.huigui150.service.ITestmjxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testmjx前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class TestmjxController {

  @Autowired
  private ITestmjxService testmjxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testmjx testmjx
   * @return
   */
  @GetMapping("/testmjxs" )
  public XfR getTestmjxs(XfPage page, Testmjx testmjx) {
    return XfR.ok(testmjxServiceImpl.page(page, Wrappers.query(testmjx)));
  }

  /**
   * 通过id查询testmjx
   * @param  id
   * @return XfR
   */
  @GetMapping("/testmjxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testmjxServiceImpl.getById(id));
  }

  /**
   * 新增testmjx
   * @param testmjx testmjx
   * @return XfR
   */
  @PostMapping("/testmjxs")
  public XfR save(@RequestBody Testmjx testmjx) {
     return XfR.ok(testmjxServiceImpl.save(testmjx));
  }

  /**
   * 修改-传入修改后的全部数据testmjx
   * @param testmjx testmjx
   * @return XfR
   */
  @PutMapping("/testmjxs/{id}")
  public XfR putUpdate(@RequestBody Testmjx testmjx,@PathVariable Long id) {
      testmjx.setId(id);
      return XfR.ok(testmjxServiceImpl.updateById(testmjx));
  }

  /**
   * 修改-传入修改的数据testmjx
   * @param testmjx testmjx
   * @return XfR
   */
  @PatchMapping("/testmjxs/{id}")
  public XfR patchUpdate(@RequestBody Testmjx testmjx,@PathVariable Long id) {
      Testmjx uptestmjx = testmjxServiceImpl.getById(id);
      if(uptestmjx != null){
        uptestmjx = ObjectCopyUtils.copyProperties(testmjx,uptestmjx,true);
      }
      return XfR.ok(testmjxServiceImpl.updateById(uptestmjx));
  }

  /**
   * 通过id删除testmjx
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testmjxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testmjxServiceImpl.removeById(id));
  }

  @PostMapping("/testmjxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testmjx");
     params.put("request", condition);

     return XfR.ok(testmjxServiceImpl.querys(params));
  }

}
