package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testxs1;
import com.xforceplus.huigui150.service.ITestxs1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testxs1前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Testxs1Controller {

  @Autowired
  private ITestxs1Service testxs1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testxs1 testxs1
   * @return
   */
  @GetMapping("/testxs1s" )
  public XfR getTestxs1s(XfPage page, Testxs1 testxs1) {
    return XfR.ok(testxs1ServiceImpl.page(page, Wrappers.query(testxs1)));
  }

  /**
   * 通过id查询testxs1
   * @param  id
   * @return XfR
   */
  @GetMapping("/testxs1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testxs1ServiceImpl.getById(id));
  }

  /**
   * 新增testxs1
   * @param testxs1 testxs1
   * @return XfR
   */
  @PostMapping("/testxs1s")
  public XfR save(@RequestBody Testxs1 testxs1) {
     return XfR.ok(testxs1ServiceImpl.save(testxs1));
  }

  /**
   * 修改-传入修改后的全部数据testxs1
   * @param testxs1 testxs1
   * @return XfR
   */
  @PutMapping("/testxs1s/{id}")
  public XfR putUpdate(@RequestBody Testxs1 testxs1,@PathVariable Long id) {
      testxs1.setId(id);
      return XfR.ok(testxs1ServiceImpl.updateById(testxs1));
  }

  /**
   * 修改-传入修改的数据testxs1
   * @param testxs1 testxs1
   * @return XfR
   */
  @PatchMapping("/testxs1s/{id}")
  public XfR patchUpdate(@RequestBody Testxs1 testxs1,@PathVariable Long id) {
      Testxs1 uptestxs1 = testxs1ServiceImpl.getById(id);
      if(uptestxs1 != null){
        uptestxs1 = ObjectCopyUtils.copyProperties(testxs1,uptestxs1,true);
      }
      return XfR.ok(testxs1ServiceImpl.updateById(uptestxs1));
  }

  /**
   * 通过id删除testxs1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testxs1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testxs1ServiceImpl.removeById(id));
  }

  @PostMapping("/testxs1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testxs1");
     params.put("request", condition);

     return XfR.ok(testxs1ServiceImpl.querys(params));
  }

}
