package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testzfc;
import com.xforceplus.huigui150.service.ITestzfcService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testzfc前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class TestzfcController {

  @Autowired
  private ITestzfcService testzfcServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testzfc testzfc
   * @return
   */
  @GetMapping("/testzfcs" )
  public XfR getTestzfcs(XfPage page, Testzfc testzfc) {
    return XfR.ok(testzfcServiceImpl.page(page, Wrappers.query(testzfc)));
  }

  /**
   * 通过id查询testzfc
   * @param  id
   * @return XfR
   */
  @GetMapping("/testzfcs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testzfcServiceImpl.getById(id));
  }

  /**
   * 新增testzfc
   * @param testzfc testzfc
   * @return XfR
   */
  @PostMapping("/testzfcs")
  public XfR save(@RequestBody Testzfc testzfc) {
     return XfR.ok(testzfcServiceImpl.save(testzfc));
  }

  /**
   * 修改-传入修改后的全部数据testzfc
   * @param testzfc testzfc
   * @return XfR
   */
  @PutMapping("/testzfcs/{id}")
  public XfR putUpdate(@RequestBody Testzfc testzfc,@PathVariable Long id) {
      testzfc.setId(id);
      return XfR.ok(testzfcServiceImpl.updateById(testzfc));
  }

  /**
   * 修改-传入修改的数据testzfc
   * @param testzfc testzfc
   * @return XfR
   */
  @PatchMapping("/testzfcs/{id}")
  public XfR patchUpdate(@RequestBody Testzfc testzfc,@PathVariable Long id) {
      Testzfc uptestzfc = testzfcServiceImpl.getById(id);
      if(uptestzfc != null){
        uptestzfc = ObjectCopyUtils.copyProperties(testzfc,uptestzfc,true);
      }
      return XfR.ok(testzfcServiceImpl.updateById(uptestzfc));
  }

  /**
   * 通过id删除testzfc
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testzfcs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testzfcServiceImpl.removeById(id));
  }

  @PostMapping("/testzfcs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testzfc");
     params.put("request", condition);

     return XfR.ok(testzfcServiceImpl.querys(params));
  }

}
