package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testzfcjihe;
import com.xforceplus.huigui150.service.ITestzfcjiheService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testzfcjihe前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class TestzfcjiheController {

  @Autowired
  private ITestzfcjiheService testzfcjiheServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testzfcjihe testzfcjihe
   * @return
   */
  @GetMapping("/testzfcjihes" )
  public XfR getTestzfcjihes(XfPage page, Testzfcjihe testzfcjihe) {
    return XfR.ok(testzfcjiheServiceImpl.page(page, Wrappers.query(testzfcjihe)));
  }

  /**
   * 通过id查询testzfcjihe
   * @param  id
   * @return XfR
   */
  @GetMapping("/testzfcjihes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testzfcjiheServiceImpl.getById(id));
  }

  /**
   * 新增testzfcjihe
   * @param testzfcjihe testzfcjihe
   * @return XfR
   */
  @PostMapping("/testzfcjihes")
  public XfR save(@RequestBody Testzfcjihe testzfcjihe) {
     return XfR.ok(testzfcjiheServiceImpl.save(testzfcjihe));
  }

  /**
   * 修改-传入修改后的全部数据testzfcjihe
   * @param testzfcjihe testzfcjihe
   * @return XfR
   */
  @PutMapping("/testzfcjihes/{id}")
  public XfR putUpdate(@RequestBody Testzfcjihe testzfcjihe,@PathVariable Long id) {
      testzfcjihe.setId(id);
      return XfR.ok(testzfcjiheServiceImpl.updateById(testzfcjihe));
  }

  /**
   * 修改-传入修改的数据testzfcjihe
   * @param testzfcjihe testzfcjihe
   * @return XfR
   */
  @PatchMapping("/testzfcjihes/{id}")
  public XfR patchUpdate(@RequestBody Testzfcjihe testzfcjihe,@PathVariable Long id) {
      Testzfcjihe uptestzfcjihe = testzfcjiheServiceImpl.getById(id);
      if(uptestzfcjihe != null){
        uptestzfcjihe = ObjectCopyUtils.copyProperties(testzfcjihe,uptestzfcjihe,true);
      }
      return XfR.ok(testzfcjiheServiceImpl.updateById(uptestzfcjihe));
  }

  /**
   * 通过id删除testzfcjihe
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testzfcjihes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testzfcjiheServiceImpl.removeById(id));
  }

  @PostMapping("/testzfcjihes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testzfcjihe");
     params.put("request", condition);

     return XfR.ok(testzfcjiheServiceImpl.querys(params));
  }

}
