package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Testzx;
import com.xforceplus.huigui150.service.ITestzxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testzx前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class TestzxController {

  @Autowired
  private ITestzxService testzxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testzx testzx
   * @return
   */
  @GetMapping("/testzxs" )
  public XfR getTestzxs(XfPage page, Testzx testzx) {
    return XfR.ok(testzxServiceImpl.page(page, Wrappers.query(testzx)));
  }

  /**
   * 通过id查询testzx
   * @param  id
   * @return XfR
   */
  @GetMapping("/testzxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testzxServiceImpl.getById(id));
  }

  /**
   * 新增testzx
   * @param testzx testzx
   * @return XfR
   */
  @PostMapping("/testzxs")
  public XfR save(@RequestBody Testzx testzx) {
     return XfR.ok(testzxServiceImpl.save(testzx));
  }

  /**
   * 修改-传入修改后的全部数据testzx
   * @param testzx testzx
   * @return XfR
   */
  @PutMapping("/testzxs/{id}")
  public XfR putUpdate(@RequestBody Testzx testzx,@PathVariable Long id) {
      testzx.setId(id);
      return XfR.ok(testzxServiceImpl.updateById(testzx));
  }

  /**
   * 修改-传入修改的数据testzx
   * @param testzx testzx
   * @return XfR
   */
  @PatchMapping("/testzxs/{id}")
  public XfR patchUpdate(@RequestBody Testzx testzx,@PathVariable Long id) {
      Testzx uptestzx = testzxServiceImpl.getById(id);
      if(uptestzx != null){
        uptestzx = ObjectCopyUtils.copyProperties(testzx,uptestzx,true);
      }
      return XfR.ok(testzxServiceImpl.updateById(uptestzx));
  }

  /**
   * 通过id删除testzx
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testzxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testzxServiceImpl.removeById(id));
  }

  @PostMapping("/testzxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testzx");
     params.put("request", condition);

     return XfR.ok(testzxServiceImpl.querys(params));
  }

}
