package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Yi0831001;
import com.xforceplus.huigui150.service.IYi0831001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * yi0831001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Yi0831001Controller {

  @Autowired
  private IYi0831001Service yi0831001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yi0831001 yi0831001
   * @return
   */
  @GetMapping("/yi0831001s" )
  public XfR getYi0831001s(XfPage page, Yi0831001 yi0831001) {
    return XfR.ok(yi0831001ServiceImpl.page(page, Wrappers.query(yi0831001)));
  }

  /**
   * 通过id查询yi0831001
   * @param  id
   * @return XfR
   */
  @GetMapping("/yi0831001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yi0831001ServiceImpl.getById(id));
  }

  /**
   * 新增yi0831001
   * @param yi0831001 yi0831001
   * @return XfR
   */
  @PostMapping("/yi0831001s")
  public XfR save(@RequestBody Yi0831001 yi0831001) {
     return XfR.ok(yi0831001ServiceImpl.save(yi0831001));
  }

  /**
   * 修改-传入修改后的全部数据yi0831001
   * @param yi0831001 yi0831001
   * @return XfR
   */
  @PutMapping("/yi0831001s/{id}")
  public XfR putUpdate(@RequestBody Yi0831001 yi0831001,@PathVariable Long id) {
      yi0831001.setId(id);
      return XfR.ok(yi0831001ServiceImpl.updateById(yi0831001));
  }

  /**
   * 修改-传入修改的数据yi0831001
   * @param yi0831001 yi0831001
   * @return XfR
   */
  @PatchMapping("/yi0831001s/{id}")
  public XfR patchUpdate(@RequestBody Yi0831001 yi0831001,@PathVariable Long id) {
      Yi0831001 upyi0831001 = yi0831001ServiceImpl.getById(id);
      if(upyi0831001 != null){
        upyi0831001 = ObjectCopyUtils.copyProperties(yi0831001,upyi0831001,true);
      }
      return XfR.ok(yi0831001ServiceImpl.updateById(upyi0831001));
  }

  /**
   * 通过id删除yi0831001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yi0831001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yi0831001ServiceImpl.removeById(id));
  }

  @PostMapping("/yi0831001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yi0831001");
     params.put("request", condition);

     return XfR.ok(yi0831001ServiceImpl.querys(params));
  }

}
