package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Yi0923001;
import com.xforceplus.huigui150.service.IYi0923001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * yi0923001前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class Yi0923001Controller {

  @Autowired
  private IYi0923001Service yi0923001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yi0923001 yi0923001
   * @return
   */
  @GetMapping("/yi0923001s" )
  public XfR getYi0923001s(XfPage page, Yi0923001 yi0923001) {
    return XfR.ok(yi0923001ServiceImpl.page(page, Wrappers.query(yi0923001)));
  }

  /**
   * 通过id查询yi0923001
   * @param  id
   * @return XfR
   */
  @GetMapping("/yi0923001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yi0923001ServiceImpl.getById(id));
  }

  /**
   * 新增yi0923001
   * @param yi0923001 yi0923001
   * @return XfR
   */
  @PostMapping("/yi0923001s")
  public XfR save(@RequestBody Yi0923001 yi0923001) {
     return XfR.ok(yi0923001ServiceImpl.save(yi0923001));
  }

  /**
   * 修改-传入修改后的全部数据yi0923001
   * @param yi0923001 yi0923001
   * @return XfR
   */
  @PutMapping("/yi0923001s/{id}")
  public XfR putUpdate(@RequestBody Yi0923001 yi0923001,@PathVariable Long id) {
      yi0923001.setId(id);
      return XfR.ok(yi0923001ServiceImpl.updateById(yi0923001));
  }

  /**
   * 修改-传入修改的数据yi0923001
   * @param yi0923001 yi0923001
   * @return XfR
   */
  @PatchMapping("/yi0923001s/{id}")
  public XfR patchUpdate(@RequestBody Yi0923001 yi0923001,@PathVariable Long id) {
      Yi0923001 upyi0923001 = yi0923001ServiceImpl.getById(id);
      if(upyi0923001 != null){
        upyi0923001 = ObjectCopyUtils.copyProperties(yi0923001,upyi0923001,true);
      }
      return XfR.ok(yi0923001ServiceImpl.updateById(upyi0923001));
  }

  /**
   * 通过id删除yi0923001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yi0923001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yi0923001ServiceImpl.removeById(id));
  }

  @PostMapping("/yi0923001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yi0923001");
     params.put("request", condition);

     return XfR.ok(yi0923001ServiceImpl.querys(params));
  }

}
