package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Yiduiduo;
import com.xforceplus.huigui150.service.IYiduiduoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * yiduiduo前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class YiduiduoController {

  @Autowired
  private IYiduiduoService yiduiduoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yiduiduo yiduiduo
   * @return
   */
  @GetMapping("/yiduiduos" )
  public XfR getYiduiduos(XfPage page, Yiduiduo yiduiduo) {
    return XfR.ok(yiduiduoServiceImpl.page(page, Wrappers.query(yiduiduo)));
  }

  /**
   * 通过id查询yiduiduo
   * @param  id
   * @return XfR
   */
  @GetMapping("/yiduiduos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yiduiduoServiceImpl.getById(id));
  }

  /**
   * 新增yiduiduo
   * @param yiduiduo yiduiduo
   * @return XfR
   */
  @PostMapping("/yiduiduos")
  public XfR save(@RequestBody Yiduiduo yiduiduo) {
     return XfR.ok(yiduiduoServiceImpl.save(yiduiduo));
  }

  /**
   * 修改-传入修改后的全部数据yiduiduo
   * @param yiduiduo yiduiduo
   * @return XfR
   */
  @PutMapping("/yiduiduos/{id}")
  public XfR putUpdate(@RequestBody Yiduiduo yiduiduo,@PathVariable Long id) {
      yiduiduo.setId(id);
      return XfR.ok(yiduiduoServiceImpl.updateById(yiduiduo));
  }

  /**
   * 修改-传入修改的数据yiduiduo
   * @param yiduiduo yiduiduo
   * @return XfR
   */
  @PatchMapping("/yiduiduos/{id}")
  public XfR patchUpdate(@RequestBody Yiduiduo yiduiduo,@PathVariable Long id) {
      Yiduiduo upyiduiduo = yiduiduoServiceImpl.getById(id);
      if(upyiduiduo != null){
        upyiduiduo = ObjectCopyUtils.copyProperties(yiduiduo,upyiduiduo,true);
      }
      return XfR.ok(yiduiduoServiceImpl.updateById(upyiduiduo));
  }

  /**
   * 通过id删除yiduiduo
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yiduiduos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yiduiduoServiceImpl.removeById(id));
  }

  @PostMapping("/yiduiduos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yiduiduo");
     params.put("request", condition);

     return XfR.ok(yiduiduoServiceImpl.querys(params));
  }

}
