package com.xforceplus.huigui150.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.huigui150.entity.Zilei;
import com.xforceplus.huigui150.service.IZileiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * zilei前端控制器
 *
 * @author ultraman
 * @date 2022-11-18
 */
@RestController
public class ZileiController {

  @Autowired
  private IZileiService zileiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei zilei
   * @return
   */
  @GetMapping("/zileis" )
  public XfR getZileis(XfPage page, Zilei zilei) {
    return XfR.ok(zileiServiceImpl.page(page, Wrappers.query(zilei)));
  }

  /**
   * 通过id查询zilei
   * @param  id
   * @return XfR
   */
  @GetMapping("/zileis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zileiServiceImpl.getById(id));
  }

  /**
   * 新增zilei
   * @param zilei zilei
   * @return XfR
   */
  @PostMapping("/zileis")
  public XfR save(@RequestBody Zilei zilei) {
     return XfR.ok(zileiServiceImpl.save(zilei));
  }

  /**
   * 修改-传入修改后的全部数据zilei
   * @param zilei zilei
   * @return XfR
   */
  @PutMapping("/zileis/{id}")
  public XfR putUpdate(@RequestBody Zilei zilei,@PathVariable Long id) {
      zilei.setId(id);
      return XfR.ok(zileiServiceImpl.updateById(zilei));
  }

  /**
   * 修改-传入修改的数据zilei
   * @param zilei zilei
   * @return XfR
   */
  @PatchMapping("/zileis/{id}")
  public XfR patchUpdate(@RequestBody Zilei zilei,@PathVariable Long id) {
      Zilei upzilei = zileiServiceImpl.getById(id);
      if(upzilei != null){
        upzilei = ObjectCopyUtils.copyProperties(zilei,upzilei,true);
      }
      return XfR.ok(zileiServiceImpl.updateById(upzilei));
  }

  /**
   * 通过id删除zilei
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zileis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zileiServiceImpl.removeById(id));
  }

  @PostMapping("/zileis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei");
     params.put("request", condition);

     return XfR.ok(zileiServiceImpl.querys(params));
  }

}
