package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.ExpensesBill;
import com.xforceplus.elephant.service.IExpensesBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-14
 */
@RestController
public class ExpensesBillController {

  @Autowired
  private IExpensesBillService expensesBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expensesBill ${table.comment}
   * @return
   */
  @GetMapping("/expensesbills" )
  public XfR getExpensesBills(XfPage page, ExpensesBill expensesBill) {
    return XfR.ok(expensesBillServiceImpl.page(page, Wrappers.query(expensesBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/expensesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expensesBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param expensesBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/expensesbills")
  public XfR save(@RequestBody ExpensesBill expensesBill) {
     return XfR.ok(expensesBillServiceImpl.save(expensesBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param expensesBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/expensesbills/{id}")
  public XfR putUpdate(@RequestBody ExpensesBill expensesBill,@PathVariable Long id) {
      expensesBill.setId(id);
      return XfR.ok(expensesBillServiceImpl.updateById(expensesBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param expensesBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/expensesbills/{id}")
  public XfR patchUpdate(@RequestBody ExpensesBill expensesBill,@PathVariable Long id) {
      ExpensesBill upexpensesBill = expensesBillServiceImpl.getById(id);
      if(upexpensesBill != null){
        upexpensesBill = ObjectCopyUtils.copyProperties(expensesBill,upexpensesBill,true);
      }
      return XfR.ok(expensesBillServiceImpl.updateById(upexpensesBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expensesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expensesBillServiceImpl.removeById(id));
  }

  @PostMapping("/expensesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "expensesbill");
      params.put("request", condition);

     return XfR.ok(expensesBillServiceImpl.querys(params));
  }

}
