package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.LogisticsPostcode;
import com.xforceplus.elephant.service.ILogisticsPostcodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-14
 */
@RestController
public class LogisticsPostcodeController {

  @Autowired
  private ILogisticsPostcodeService logisticsPostcodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param logisticsPostcode ${table.comment}
   * @return
   */
  @GetMapping("/logisticspostcodes" )
  public XfR getLogisticsPostcodes(XfPage page, LogisticsPostcode logisticsPostcode) {
    return XfR.ok(logisticsPostcodeServiceImpl.page(page, Wrappers.query(logisticsPostcode)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/logisticspostcodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(logisticsPostcodeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param logisticsPostcode ${table.comment}
   * @return XfR
   */
  @PostMapping("/logisticspostcodes")
  public XfR save(@RequestBody LogisticsPostcode logisticsPostcode) {
     return XfR.ok(logisticsPostcodeServiceImpl.save(logisticsPostcode));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param logisticsPostcode ${table.comment}
   * @return XfR
   */
  @PutMapping("/logisticspostcodes/{id}")
  public XfR putUpdate(@RequestBody LogisticsPostcode logisticsPostcode,@PathVariable Long id) {
      logisticsPostcode.setId(id);
      return XfR.ok(logisticsPostcodeServiceImpl.updateById(logisticsPostcode));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param logisticsPostcode ${table.comment}
   * @return XfR
   */
  @PatchMapping("/logisticspostcodes/{id}")
  public XfR patchUpdate(@RequestBody LogisticsPostcode logisticsPostcode,@PathVariable Long id) {
      LogisticsPostcode uplogisticsPostcode = logisticsPostcodeServiceImpl.getById(id);
      if(uplogisticsPostcode != null){
        uplogisticsPostcode = ObjectCopyUtils.copyProperties(logisticsPostcode,uplogisticsPostcode,true);
      }
      return XfR.ok(logisticsPostcodeServiceImpl.updateById(uplogisticsPostcode));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/logisticspostcodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(logisticsPostcodeServiceImpl.removeById(id));
  }

  @PostMapping("/logisticspostcodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "logisticspostcode");
      params.put("request", condition);

     return XfR.ok(logisticsPostcodeServiceImpl.querys(params));
  }

}
