package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.PurchaseBill;
import com.xforceplus.elephant.service.IPurchaseBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-10
 */
@RestController
public class PurchaseBillController {

  @Autowired
  private IPurchaseBillService purchaseBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseBill ${table.comment}
   * @return
   */
  @GetMapping("/purchasebills" )
  public XfR getPurchaseBills(XfPage page, PurchaseBill purchaseBill) {
    return XfR.ok(purchaseBillServiceImpl.page(page, Wrappers.query(purchaseBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchasebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchasebills")
  public XfR save(@RequestBody PurchaseBill purchaseBill) {
     return XfR.ok(purchaseBillServiceImpl.save(purchaseBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchasebills/{id}")
  public XfR putUpdate(@RequestBody PurchaseBill purchaseBill,@PathVariable Long id) {
      purchaseBill.setId(id);
      return XfR.ok(purchaseBillServiceImpl.updateById(purchaseBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchasebills/{id}")
  public XfR patchUpdate(@RequestBody PurchaseBill purchaseBill,@PathVariable Long id) {
      PurchaseBill uppurchaseBill = purchaseBillServiceImpl.getById(id);
      if(uppurchaseBill != null){
        uppurchaseBill = ObjectCopyUtils.copyProperties(purchaseBill,uppurchaseBill,true);
      }
      return XfR.ok(purchaseBillServiceImpl.updateById(uppurchaseBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchasebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseBillServiceImpl.removeById(id));
  }

  @PostMapping("/purchasebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "purchasebill");
      params.put("request", condition);

     return XfR.ok(purchaseBillServiceImpl.querys(params));
  }

}
