package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.TicketForm;
import com.xforceplus.elephant.service.ITicketFormService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-10
 */
@RestController
public class TicketFormController {

  @Autowired
  private ITicketFormService ticketFormServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketForm ${table.comment}
   * @return
   */
  @GetMapping("/ticketforms" )
  public XfR getTicketForms(XfPage page, TicketForm ticketForm) {
    return XfR.ok(ticketFormServiceImpl.page(page, Wrappers.query(ticketForm)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketforms/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketFormServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketForm ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketforms")
  public XfR save(@RequestBody TicketForm ticketForm) {
     return XfR.ok(ticketFormServiceImpl.save(ticketForm));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketForm ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketforms/{id}")
  public XfR putUpdate(@RequestBody TicketForm ticketForm,@PathVariable Long id) {
      ticketForm.setId(id);
      return XfR.ok(ticketFormServiceImpl.updateById(ticketForm));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketForm ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketforms/{id}")
  public XfR patchUpdate(@RequestBody TicketForm ticketForm,@PathVariable Long id) {
      TicketForm upticketForm = ticketFormServiceImpl.getById(id);
      if(upticketForm != null){
        upticketForm = ObjectCopyUtils.copyProperties(ticketForm,upticketForm,true);
      }
      return XfR.ok(ticketFormServiceImpl.updateById(upticketForm));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketforms/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketFormServiceImpl.removeById(id));
  }

  @PostMapping("/ticketforms/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ticketform");
      params.put("request", condition);

     return XfR.ok(ticketFormServiceImpl.querys(params));
  }

}
