package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.TicketAttachment;
import com.xforceplus.elephant.service.ITicketAttachmentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-17
 */
@RestController
public class TicketAttachmentController {

  @Autowired
  private ITicketAttachmentService ticketAttachmentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketAttachment ${table.comment}
   * @return
   */
  @GetMapping("/ticketattachments" )
  public XfR getTicketAttachments(XfPage page, TicketAttachment ticketAttachment) {
    return XfR.ok(ticketAttachmentServiceImpl.page(page, Wrappers.query(ticketAttachment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketattachments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketAttachmentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketAttachment ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketattachments")
  public XfR save(@RequestBody TicketAttachment ticketAttachment) {
     return XfR.ok(ticketAttachmentServiceImpl.save(ticketAttachment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketAttachment ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketattachments/{id}")
  public XfR putUpdate(@RequestBody TicketAttachment ticketAttachment,@PathVariable Long id) {
      ticketAttachment.setId(id);
      return XfR.ok(ticketAttachmentServiceImpl.updateById(ticketAttachment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketAttachment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketattachments/{id}")
  public XfR patchUpdate(@RequestBody TicketAttachment ticketAttachment,@PathVariable Long id) {
      TicketAttachment upticketAttachment = ticketAttachmentServiceImpl.getById(id);
      if(upticketAttachment != null){
        upticketAttachment = ObjectCopyUtils.copyProperties(ticketAttachment,upticketAttachment,true);
      }
      return XfR.ok(ticketAttachmentServiceImpl.updateById(upticketAttachment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketattachments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketAttachmentServiceImpl.removeById(id));
  }

  @PostMapping("/ticketattachments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ticketattachment");
      params.put("request", condition);

     return XfR.ok(ticketAttachmentServiceImpl.querys(params));
  }

}
