package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.ReceiveFiles;
import com.xforceplus.elephant.service.IReceiveFilesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-01
 */
@RestController
public class ReceiveFilesController {

  @Autowired
  private IReceiveFilesService receiveFilesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receiveFiles ${table.comment}
   * @return
   */
  @GetMapping("/receivefiless" )
  public XfR getReceiveFiless(XfPage page, ReceiveFiles receiveFiles) {
    return XfR.ok(receiveFilesServiceImpl.page(page, Wrappers.query(receiveFiles)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivefiless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receiveFilesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receiveFiles ${table.comment}
   * @return XfR
   */
  @PostMapping("/receivefiless")
  public XfR save(@RequestBody ReceiveFiles receiveFiles) {
     return XfR.ok(receiveFilesServiceImpl.save(receiveFiles));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receiveFiles ${table.comment}
   * @return XfR
   */
  @PutMapping("/receivefiless/{id}")
  public XfR putUpdate(@RequestBody ReceiveFiles receiveFiles,@PathVariable Long id) {
      receiveFiles.setId(id);
      return XfR.ok(receiveFilesServiceImpl.updateById(receiveFiles));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receiveFiles ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receivefiless/{id}")
  public XfR patchUpdate(@RequestBody ReceiveFiles receiveFiles,@PathVariable Long id) {
      ReceiveFiles upreceiveFiles = receiveFilesServiceImpl.getById(id);
      if(upreceiveFiles != null){
        upreceiveFiles = ObjectCopyUtils.copyProperties(receiveFiles,upreceiveFiles,true);
      }
      return XfR.ok(receiveFilesServiceImpl.updateById(upreceiveFiles));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivefiless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receiveFilesServiceImpl.removeById(id));
  }

  @PostMapping("/receivefiless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "receivefiles");
      params.put("request", condition);

     return XfR.ok(receiveFilesServiceImpl.querys(params));
  }

}
