package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.TicketSalesList;
import com.xforceplus.elephant.service.ITicketSalesListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-01
 */
@RestController
public class TicketSalesListController {

  @Autowired
  private ITicketSalesListService ticketSalesListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketSalesList ${table.comment}
   * @return
   */
  @GetMapping("/ticketsaleslists" )
  public XfR getTicketSalesLists(XfPage page, TicketSalesList ticketSalesList) {
    return XfR.ok(ticketSalesListServiceImpl.page(page, Wrappers.query(ticketSalesList)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketsaleslists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketSalesListServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketSalesList ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketsaleslists")
  public XfR save(@RequestBody TicketSalesList ticketSalesList) {
     return XfR.ok(ticketSalesListServiceImpl.save(ticketSalesList));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketSalesList ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketsaleslists/{id}")
  public XfR putUpdate(@RequestBody TicketSalesList ticketSalesList,@PathVariable Long id) {
      ticketSalesList.setId(id);
      return XfR.ok(ticketSalesListServiceImpl.updateById(ticketSalesList));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketSalesList ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketsaleslists/{id}")
  public XfR patchUpdate(@RequestBody TicketSalesList ticketSalesList,@PathVariable Long id) {
      TicketSalesList upticketSalesList = ticketSalesListServiceImpl.getById(id);
      if(upticketSalesList != null){
        upticketSalesList = ObjectCopyUtils.copyProperties(ticketSalesList,upticketSalesList,true);
      }
      return XfR.ok(ticketSalesListServiceImpl.updateById(upticketSalesList));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketsaleslists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketSalesListServiceImpl.removeById(id));
  }

  @PostMapping("/ticketsaleslists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ticketsaleslist");
      params.put("request", condition);

     return XfR.ok(ticketSalesListServiceImpl.querys(params));
  }

}
