package com.xforceplus.imagesaas.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.BatchNumberRule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface BatchNumberRuleFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/batchNumberRule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param batchNumberRule ${table.comment}
   * @return R
   */
  @PostMapping("/batchNumberRule/add")
  public R save(@RequestBody BatchNumberRule batchNumberRule);

  /**
   * 修改${table.comment}
   * @param batchNumberRule ${table.comment}
   * @return R
   */
  @PostMapping("/batchNumberRule/update")
  public R updateById(@RequestBody BatchNumberRule batchNumberRule);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/batchNumberRule/del/{id}" )
  public R removeById(@PathVariable Long id);

}