package com.xforceplus.imagesaas.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-03-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.TaskHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface TaskHistoryFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/taskHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param taskHistory ${table.comment}
   * @return R
   */
  @PostMapping("/taskHistory/add")
  public R save(@RequestBody TaskHistory taskHistory);

  /**
   * 修改${table.comment}
   * @param taskHistory ${table.comment}
   * @return R
   */
  @PostMapping("/taskHistory/update")
  public R updateById(@RequestBody TaskHistory taskHistory);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/taskHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}