package com.xforceplus.imagesaas.controller;


/**
 * 业务日志feign客户端
 *
 * @author ultraman
 * @date 2023-05-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.BusinessLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface BusinessLogFeignApi {

  /**
   * 通过id查询业务日志
   * @param  id
   * @return R
   */
  @GetMapping("/businessLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务日志
   * @param businessLog 业务日志
   * @return R
   */
  @PostMapping("/businessLog/add")
  public R save(@RequestBody BusinessLog businessLog);

  /**
   * 修改业务日志
   * @param businessLog 业务日志
   * @return R
   */
  @PostMapping("/businessLog/update")
  public R updateById(@RequestBody BusinessLog businessLog);

  /**
   * 通过id删除业务日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/businessLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}