package com.xforceplus.imagesaas.controller;


/**
 * 其他发票feign客户端
 *
 * @author ultraman
 * @date 2023-05-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.TicketOther;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface TicketOtherFeignApi {

  /**
   * 通过id查询其他发票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketOther/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增其他发票
   * @param ticketOther 其他发票
   * @return R
   */
  @PostMapping("/ticketOther/add")
  public R save(@RequestBody TicketOther ticketOther);

  /**
   * 修改其他发票
   * @param ticketOther 其他发票
   * @return R
   */
  @PostMapping("/ticketOther/update")
  public R updateById(@RequestBody TicketOther ticketOther);

  /**
   * 通过id删除其他发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketOther/del/{id}" )
  public R removeById(@PathVariable Long id);

}