package com.xforceplus.imagesaas.controller;


/**
 * 中南置地-成本合同付款feign客户端
 *
 * @author ultraman
 * @date 2024-04-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CbHtfk;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CbHtfkFeignApi {

  /**
   * 通过id查询中南置地-成本合同付款
   * @param  id
   * @return R
   */
  @GetMapping("/cbHtfk/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增中南置地-成本合同付款
   * @param cbHtfk 中南置地-成本合同付款
   * @return R
   */
  @PostMapping("/cbHtfk/add")
  public R save(@RequestBody CbHtfk cbHtfk);

  /**
   * 修改中南置地-成本合同付款
   * @param cbHtfk 中南置地-成本合同付款
   * @return R
   */
  @PostMapping("/cbHtfk/update")
  public R updateById(@RequestBody CbHtfk cbHtfk);

  /**
   * 通过id删除中南置地-成本合同付款
   * @param  id
   * @return R
   */
  @DeleteMapping("/cbHtfk/del/{id}" )
  public R removeById(@PathVariable Long id);

}