package com.xforceplus.imagesaas.controller;


/**
 * 比对财政票据feign客户端
 *
 * @author ultraman
 * @date 2024-04-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketFinance;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketFinanceFeignApi {

  /**
   * 通过id查询比对财政票据
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketFinance/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对财政票据
   * @param compareTicketFinance 比对财政票据
   * @return R
   */
  @PostMapping("/compareTicketFinance/add")
  public R save(@RequestBody CompareTicketFinance compareTicketFinance);

  /**
   * 修改比对财政票据
   * @param compareTicketFinance 比对财政票据
   * @return R
   */
  @PostMapping("/compareTicketFinance/update")
  public R updateById(@RequestBody CompareTicketFinance compareTicketFinance);

  /**
   * 通过id删除比对财政票据
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketFinance/del/{id}" )
  public R removeById(@PathVariable Long id);

}