package com.xforceplus.imagesaas.controller;


/**
 * 运维日志feign客户端
 *
 * @author ultraman
 * @date 2024-04-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imagesaas.entity.OperationLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface OperationLogFeignApi {

  /**
   * 通过id查询运维日志
   * @param  id
   * @return R
   */
  @GetMapping("/operationLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增运维日志
   * @param operationLog 运维日志
   * @return R
   */
  @PostMapping("/operationLog/add")
  public R save(@RequestBody OperationLog operationLog);

  /**
   * 修改运维日志
   * @param operationLog 运维日志
   * @return R
   */
  @PostMapping("/operationLog/update")
  public R updateById(@RequestBody OperationLog operationLog);

  /**
   * 通过id删除运维日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/operationLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}