package com.xforceplus.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据状态
 * </p>
 *
 * @author ultraman
 * @since 2021-06-08
 */
public enum BillDataStatus {

    _0("0", "待提交"),
    _2("2", "暂挂起"),
    _6("6", "已提交"),
    _3("3", "已锁定"),
    _4("4", "已退回"),
    _5("5", "已作废"),
    _1("1", "已完成");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillDataStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillDataStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "6":
                return _6;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
