package com.xforceplus.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-06-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Image implements Serializable {

  private static final long serialVersionUID=1L;

  private String imageType;

  private String imageSource;

  private String requireOcrFlag;

  private String fileUrl;

  private String fileUrlHandle;

  private String fileUrlOrigin;

  private String fileType;

  private String fileTypeHandle;

  private String fileOrder;

  private Long fileLevel;

  private String recStatus;

  private String taskId;

  private Long copyCount;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recStartTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recEndTime;

  private Long billImageId;

  private Long ticketImageId;

  private String status;

  private String isManualUnhook;

  private String isPublic;

  private String exceptionStatus;

  private String returnStatus;

  private String batchNo;

  private String imageCategory;

  private String returnReason;

  private String returnRemark;

  private String reserved1;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String billCode;

  private String reserved2;

  private String reserved3;

  private String fileUrlLocal;

  private String isReuse;

  private String pageCode;

  private String billEntityCode;

  private String createUserCode;

  private String moreFileUrl;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  private String exceptionInfo;

  private String warningInfo;

  private String isCommit;

  private Long commitUserId;

  private String commitUserName;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime commitTime;

  private String returnType;

  private Long orgId;

  private String orgName;

  private String orgCode;

  private String calculateStatus;

  private String fileName;

  private String ticketCode;

  private Long fileId;

  private String serialNumber;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("image_type", imageType);
      map.put("image_source", imageSource);
      map.put("require_ocr_flag", requireOcrFlag);
      map.put("file_url", fileUrl);
      map.put("file_url_handle", fileUrlHandle);
      map.put("file_url_origin", fileUrlOrigin);
      map.put("file_type", fileType);
      map.put("file_type_handle", fileTypeHandle);
      map.put("file_order", fileOrder);
      map.put("file_level", fileLevel);
      map.put("rec_status", recStatus);
      map.put("task_id", taskId);
      map.put("copy_count", copyCount);
      map.put("rec_start_time", BocpGenUtils.toTimestamp(recStartTime));
      map.put("rec_end_time", BocpGenUtils.toTimestamp(recEndTime));
      map.put("bill_image_id", billImageId);
      map.put("ticket_image_id", ticketImageId);
      map.put("status", status);
      map.put("is_manual_unhook", isManualUnhook);
      map.put("is_public", isPublic);
      map.put("exception_status", exceptionStatus);
      map.put("return_status", returnStatus);
      map.put("batch_no", batchNo);
      map.put("image_category", imageCategory);
      map.put("return_reason", returnReason);
      map.put("return_remark", returnRemark);
      map.put("reserved1", reserved1);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("bill_code", billCode);
      map.put("reserved2", reserved2);
      map.put("reserved3", reserved3);
      map.put("file_url_local", fileUrlLocal);
      map.put("is_reuse", isReuse);
      map.put("page_code", pageCode);
      map.put("bill_entity_code", billEntityCode);
      map.put("create_user_code", createUserCode);
      map.put("more_file_url", moreFileUrl);
      map.put("tenant_code", tenantCode);
      map.put("exception_info", exceptionInfo);
      map.put("warning_info", warningInfo);
      map.put("is_commit", isCommit);
      map.put("commit_user_id", commitUserId);
      map.put("commit_user_name", commitUserName);
      map.put("commit_time", BocpGenUtils.toTimestamp(commitTime));
      map.put("return_type", returnType);
      map.put("org_id", orgId);
      map.put("org_name", orgName);
      map.put("org_code", orgCode);
      map.put("calculate_status", calculateStatus);
      map.put("file_name", fileName);
      map.put("ticket_code", ticketCode);
      map.put("file_id", fileId);
      map.put("serial_number", serialNumber);
      return map;
  }

  public static Image fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    Image entity = new Image();
    if(map.containsKey("image_type")) {
      Object obj = map.get("image_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("image_source")) {
      Object obj = map.get("image_source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("require_ocr_flag")) {
      Object obj = map.get("require_ocr_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequireOcrFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url")) {
      Object obj = map.get("file_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url_handle")) {
      Object obj = map.get("file_url_handle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrlHandle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url_origin")) {
      Object obj = map.get("file_url_origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrlOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_type")) {
      Object obj = map.get("file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_type_handle")) {
      Object obj = map.get("file_type_handle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileTypeHandle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_order")) {
      Object obj = map.get("file_order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_level")) {
      Object obj = map.get("file_level");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFileLevel((Long)obj);
        } else if(obj instanceof String) {
          entity.setFileLevel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFileLevel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rec_status")) {
      Object obj = map.get("rec_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("task_id")) {
      Object obj = map.get("task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("copy_count")) {
      Object obj = map.get("copy_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCopyCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setCopyCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCopyCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rec_start_time")) {
      Object obj = map.get("rec_start_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRecStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRecStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecStartTime(null);
      }
    }
    if(map.containsKey("rec_end_time")) {
      Object obj = map.get("rec_end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRecEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRecEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecEndTime(null);
      }
    }
    if(map.containsKey("bill_image_id")) {
      Object obj = map.get("bill_image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillImageId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ticket_image_id")) {
      Object obj = map.get("ticket_image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTicketImageId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTicketImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTicketImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_manual_unhook")) {
      Object obj = map.get("is_manual_unhook");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsManualUnhook((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPublic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_status")) {
      Object obj = map.get("exception_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_status")) {
      Object obj = map.get("return_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("image_category")) {
      Object obj = map.get("image_category");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_reason")) {
      Object obj = map.get("return_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_remark")) {
      Object obj = map.get("return_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url_local")) {
      Object obj = map.get("file_url_local");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrlLocal((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_reuse")) {
      Object obj = map.get("is_reuse");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsReuse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("page_code")) {
      Object obj = map.get("page_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPageCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_entity_code")) {
      Object obj = map.get("bill_entity_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillEntityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("more_file_url")) {
      Object obj = map.get("more_file_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMoreFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_commit")) {
      Object obj = map.get("is_commit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCommit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCommitTime(null);
      }
    }
    if(map.containsKey("return_type")) {
      Object obj = map.get("return_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCalculateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_name")) {
      Object obj = map.get("file_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_code")) {
      Object obj = map.get("ticket_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_id")) {
      Object obj = map.get("file_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFileId((Long)obj);
        } else if(obj instanceof String) {
          entity.setFileId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFileId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
