package com.xforceplus.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据类型
 * </p>
 *
 * @author ultraman
 * @since 2021-07-05
 */
public enum BillTypeCode {

    _0("0", "-");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillTypeCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTypeCode fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
