package com.xforceplus.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ConfigSettings implements Serializable {

  private static final long serialVersionUID=1L;

  private String isDefault;

  private String enable;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private Long tenant;

  private Long imageToAnnexSeconds;

  private String scanIsSupportAllTenant;

  private Long searchNoRealDay;

  private String ticketAutoSendVerify;

  private String isAllPushData;

  private String ticketIsSupportReuse;

  private String ticketIsCheckBlack;

  private String ticketIsCheckSensitive;

  private String ticketIsCheckLegalperson;

  private String billCodeIsNeedTrans;

  private String emptyUrl;

  private String isSupportPszs;

  private String debugModel;

  private String splitMoreImage;

  private String billTypeCodeNeedList;

  private String billCodeRegexSplit;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  private String extension1;

  private String extension2;

  private String extension3;

  private String salesListConfig;

  private String scanClientScanModel;

  private Long sharepointSendImageNum;

  private String websocketUrl;

  private String discernEntityCodes;

  private Long fileToAnnexSeconds;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("is_default", isDefault);
      map.put("enable", enable);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant", tenant);
      map.put("image_to_annex_seconds", imageToAnnexSeconds);
      map.put("scan_is_support_all_tenant", scanIsSupportAllTenant);
      map.put("search_no_real_day", searchNoRealDay);
      map.put("ticket_auto_send_verify", ticketAutoSendVerify);
      map.put("is_all_push_data", isAllPushData);
      map.put("ticket_is_support_reuse", ticketIsSupportReuse);
      map.put("ticket_is_check_black", ticketIsCheckBlack);
      map.put("ticket_is_check_sensitive", ticketIsCheckSensitive);
      map.put("ticket_is_check_legalperson", ticketIsCheckLegalperson);
      map.put("bill_code_is_need_trans", billCodeIsNeedTrans);
      map.put("empty_url", emptyUrl);
      map.put("is_support_pszs", isSupportPszs);
      map.put("debug_model", debugModel);
      map.put("split_more_image", splitMoreImage);
      map.put("bill_type_code_need_list", billTypeCodeNeedList);
      map.put("bill_code_regex_split", billCodeRegexSplit);
      map.put("tenant_code", tenantCode);
      map.put("extension1", extension1);
      map.put("extension2", extension2);
      map.put("extension3", extension3);
      map.put("sales_list_config", salesListConfig);
      map.put("scan_client_scan_model", scanClientScanModel);
      map.put("sharepoint_send_image_num", sharepointSendImageNum);
      map.put("websocket_url", websocketUrl);
      map.put("discern_entity_codes", discernEntityCodes);
      map.put("file_to_annex_seconds", fileToAnnexSeconds);
      return map;
  }

  public static ConfigSettings fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    ConfigSettings entity = new ConfigSettings();
    if(map.containsKey("is_default")) {
      Object obj = map.get("is_default");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDefault((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enable")) {
      Object obj = map.get("enable");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenant((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenant(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenant(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("image_to_annex_seconds")) {
      Object obj = map.get("image_to_annex_seconds");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageToAnnexSeconds((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageToAnnexSeconds(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageToAnnexSeconds(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("scan_is_support_all_tenant")) {
      Object obj = map.get("scan_is_support_all_tenant");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanIsSupportAllTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("search_no_real_day")) {
      Object obj = map.get("search_no_real_day");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSearchNoRealDay((Long)obj);
        } else if(obj instanceof String) {
          entity.setSearchNoRealDay(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSearchNoRealDay(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ticket_auto_send_verify")) {
      Object obj = map.get("ticket_auto_send_verify");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketAutoSendVerify((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_all_push_data")) {
      Object obj = map.get("is_all_push_data");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsAllPushData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_is_support_reuse")) {
      Object obj = map.get("ticket_is_support_reuse");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketIsSupportReuse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_is_check_black")) {
      Object obj = map.get("ticket_is_check_black");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketIsCheckBlack((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_is_check_sensitive")) {
      Object obj = map.get("ticket_is_check_sensitive");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketIsCheckSensitive((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_is_check_legalperson")) {
      Object obj = map.get("ticket_is_check_legalperson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketIsCheckLegalperson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code_is_need_trans")) {
      Object obj = map.get("bill_code_is_need_trans");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCodeIsNeedTrans((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("empty_url")) {
      Object obj = map.get("empty_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEmptyUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_support_pszs")) {
      Object obj = map.get("is_support_pszs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsSupportPszs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("debug_model")) {
      Object obj = map.get("debug_model");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDebugModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("split_more_image")) {
      Object obj = map.get("split_more_image");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSplitMoreImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_code_need_list")) {
      Object obj = map.get("bill_type_code_need_list");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTypeCodeNeedList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code_regex_split")) {
      Object obj = map.get("bill_code_regex_split");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCodeRegexSplit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extension1")) {
      Object obj = map.get("extension1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtension1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extension2")) {
      Object obj = map.get("extension2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtension2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extension3")) {
      Object obj = map.get("extension3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtension3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_list_config")) {
      Object obj = map.get("sales_list_config");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesListConfig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_client_scan_model")) {
      Object obj = map.get("scan_client_scan_model");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanClientScanModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sharepoint_send_image_num")) {
      Object obj = map.get("sharepoint_send_image_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSharepointSendImageNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setSharepointSendImageNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSharepointSendImageNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("websocket_url")) {
      Object obj = map.get("websocket_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWebsocketUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discern_entity_codes")) {
      Object obj = map.get("discern_entity_codes");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscernEntityCodes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_to_annex_seconds")) {
      Object obj = map.get("file_to_annex_seconds");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFileToAnnexSeconds((Long)obj);
        } else if(obj instanceof String) {
          entity.setFileToAnnexSeconds(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFileToAnnexSeconds(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
