package com.xforceplus.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 数据对比用途的影像
 * </p>
 *
 * @author ultraman
 * @since 2022-06-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompareImage implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 影像类型
   */
  private String imageType;

  /**
   * 来源
   */
  private String imageSource;

  /**
   * 是否需要识别
   */
  private String requireOcrFlag;

  /**
   * 原始文件路径
   */
  private String fileUrl;

  /**
   * 处理文件路径
   */
  private String fileUrlHandle;

  /**
   * 原处理文件路径
   */
  private String fileUrlOrigin;

  /**
   * 原始文件类型
   */
  private String fileType;

  /**
   * 处理文件类型
   */
  private String fileTypeHandle;

  /**
   * 文件顺序
   */
  private String fileOrder;

  /**
   * 文件level
   */
  private Long fileLevel;

  /**
   * 识别状态
   */
  private String recStatus;

  /**
   * 识别任务编号
   */
  private String taskId;

  /**
   * 副本数量
   */
  private Long copyCount;

  /**
   * 识别开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recStartTime;

  /**
   * 识别结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recEndTime;

  /**
   * 所属单据的影像ID
   */
  private Long billImageId;

  /**
   * 所属单证的影像ID
   */
  private Long ticketImageId;

  /**
   * 状态
   */
  private String status;

  /**
   * 是否手动脱挂
   */
  private String isManualUnhook;

  /**
   * 是否公共
   */
  private String isPublic;

  /**
   * 异常状态
   */
  private String exceptionStatus;

  /**
   * 退回状态
   */
  private String returnStatus;

  /**
   * 扫描批次号
   */
  private String batchNo;

  /**
   * 影像大类别
   */
  private String imageCategory;

  /**
   * 退回原因
   */
  private String returnReason;

  /**
   * 退回备注
   */
  private String returnRemark;

  /**
   * 保留字段1
   */
  private String reserved1;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 业务单号
   */
  private String billCode;

  /**
   * 保留字段2
   */
  private String reserved2;

  /**
   * 保留字段3
   */
  private String reserved3;

  /**
   * 属地文件路径
   */
  private String fileUrlLocal;

  /**
   * 是否复用
   */
  private String isReuse;

  /**
   * 上传所属页面
   */
  private String pageCode;

  /**
   * 上传所属单据对象
   */
  private String billEntityCode;

  /**
   * 创建用户代码
   */
  private String createUserCode;

  /**
   * 多票地址
   */
  private String moreFileUrl;

  /**
   * 租户名称
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 异常信息
   */
  private String exceptionInfo;

  /**
   * 预警信息
   */
  private String warningInfo;

  /**
   * 是否提交
   */
  private String isCommit;

  /**
   * 提交人ID
   */
  private Long commitUserId;

  /**
   * 提交人姓名
   */
  private String commitUserName;

  /**
   * 提交时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime commitTime;

  /**
   * 退回类型
   */
  private String returnType;

  /**
   * 所属组织ID
   */
  private Long orgId;

  /**
   * 所属组织
   */
  private String orgName;

  /**
   * 所属组织代码
   */
  private String orgCode;

  /**
   * 计算状态
   */
  private String calculateStatus;

  /**
   * 文件名
   */
  private String fileName;

  /**
   * 单证Code
   */
  private String ticketCode;

  /**
   * 文件id
   */
  private Long fileId;

  /**
   * 流水号
   */
  private String serialNumber;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 协同销方税号
   */
  private String sellerTaxNo;

  /**
   * 单证预置数据
   */
  private String ticketPreData;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("image_type", imageType);
      map.put("image_source", imageSource);
      map.put("require_ocr_flag", requireOcrFlag);
      map.put("file_url", fileUrl);
      map.put("file_url_handle", fileUrlHandle);
      map.put("file_url_origin", fileUrlOrigin);
      map.put("file_type", fileType);
      map.put("file_type_handle", fileTypeHandle);
      map.put("file_order", fileOrder);
      map.put("file_level", fileLevel);
      map.put("rec_status", recStatus);
      map.put("task_id", taskId);
      map.put("copy_count", copyCount);
      map.put("rec_start_time", BocpGenUtils.toTimestamp(recStartTime));
      map.put("rec_end_time", BocpGenUtils.toTimestamp(recEndTime));
      map.put("bill_image_id", billImageId);
      map.put("ticket_image_id", ticketImageId);
      map.put("status", status);
      map.put("is_manual_unhook", isManualUnhook);
      map.put("is_public", isPublic);
      map.put("exception_status", exceptionStatus);
      map.put("return_status", returnStatus);
      map.put("batch_no", batchNo);
      map.put("image_category", imageCategory);
      map.put("return_reason", returnReason);
      map.put("return_remark", returnRemark);
      map.put("reserved1", reserved1);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("bill_code", billCode);
      map.put("reserved2", reserved2);
      map.put("reserved3", reserved3);
      map.put("file_url_local", fileUrlLocal);
      map.put("is_reuse", isReuse);
      map.put("page_code", pageCode);
      map.put("bill_entity_code", billEntityCode);
      map.put("create_user_code", createUserCode);
      map.put("more_file_url", moreFileUrl);
      map.put("tenant_code", tenantCode);
      map.put("exception_info", exceptionInfo);
      map.put("warning_info", warningInfo);
      map.put("is_commit", isCommit);
      map.put("commit_user_id", commitUserId);
      map.put("commit_user_name", commitUserName);
      map.put("commit_time", BocpGenUtils.toTimestamp(commitTime));
      map.put("return_type", returnType);
      map.put("org_id", orgId);
      map.put("org_name", orgName);
      map.put("org_code", orgCode);
      map.put("calculate_status", calculateStatus);
      map.put("file_name", fileName);
      map.put("ticket_code", ticketCode);
      map.put("file_id", fileId);
      map.put("serial_number", serialNumber);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("ticket_pre_data", ticketPreData);
      return map;
  }

  public static CompareImage fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CompareImage entity = new CompareImage();
    if(map.containsKey("image_type")) {
      Object obj = map.get("image_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("image_source")) {
      Object obj = map.get("image_source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("require_ocr_flag")) {
      Object obj = map.get("require_ocr_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequireOcrFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url")) {
      Object obj = map.get("file_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url_handle")) {
      Object obj = map.get("file_url_handle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrlHandle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url_origin")) {
      Object obj = map.get("file_url_origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrlOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_type")) {
      Object obj = map.get("file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_type_handle")) {
      Object obj = map.get("file_type_handle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileTypeHandle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_order")) {
      Object obj = map.get("file_order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_level")) {
      Object obj = map.get("file_level");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFileLevel((Long)obj);
        } else if(obj instanceof String) {
          entity.setFileLevel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFileLevel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rec_status")) {
      Object obj = map.get("rec_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("task_id")) {
      Object obj = map.get("task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("copy_count")) {
      Object obj = map.get("copy_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCopyCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setCopyCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCopyCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rec_start_time")) {
      Object obj = map.get("rec_start_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRecStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRecStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecStartTime(null);
      }
    }
    if(map.containsKey("rec_end_time")) {
      Object obj = map.get("rec_end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRecEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRecEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecEndTime(null);
      }
    }
    if(map.containsKey("bill_image_id")) {
      Object obj = map.get("bill_image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillImageId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ticket_image_id")) {
      Object obj = map.get("ticket_image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTicketImageId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTicketImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTicketImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_manual_unhook")) {
      Object obj = map.get("is_manual_unhook");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsManualUnhook((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPublic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_status")) {
      Object obj = map.get("exception_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_status")) {
      Object obj = map.get("return_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("image_category")) {
      Object obj = map.get("image_category");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_reason")) {
      Object obj = map.get("return_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_remark")) {
      Object obj = map.get("return_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url_local")) {
      Object obj = map.get("file_url_local");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrlLocal((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_reuse")) {
      Object obj = map.get("is_reuse");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsReuse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("page_code")) {
      Object obj = map.get("page_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPageCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_entity_code")) {
      Object obj = map.get("bill_entity_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillEntityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("more_file_url")) {
      Object obj = map.get("more_file_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMoreFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_commit")) {
      Object obj = map.get("is_commit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCommit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCommitTime(null);
      }
    }
    if(map.containsKey("return_type")) {
      Object obj = map.get("return_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReturnType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCalculateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_name")) {
      Object obj = map.get("file_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_code")) {
      Object obj = map.get("ticket_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_id")) {
      Object obj = map.get("file_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFileId((Long)obj);
        } else if(obj instanceof String) {
          entity.setFileId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFileId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_pre_data")) {
      Object obj = map.get("ticket_pre_data");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketPreData((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
