package com.xforceplus.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.imagesaas.entity.Ticket;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-06-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketTrain extends Ticket {


  /**
   * 姓名
   */
  private String name;

  /**
   * 车次
   */
  private String trains;

  /**
   * 出发站
   */
  private String startStation;

  /**
   * 目的站
   */
  private String endStation;

  /**
   * 出发日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  /**
   * 出发时间
   */
  private String startTime;

  /**
   * 座位号
   */
  private String seat;

  /**
   * 座位类型
   */
  private String seatType;

  /**
   * 凭证号
   */
  private String certificateNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("name", name);
      map.put("trains", trains);
      map.put("start_station", startStation);
      map.put("end_station", endStation);
      map.put("start_date", BocpGenUtils.toTimestamp(startDate));
      map.put("start_time", startTime);
      map.put("seat", seat);
      map.put("seat_type", seatType);
      map.put("certificate_no", certificateNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static TicketTrain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketTrain entity = new TicketTrain();
    if(map.containsKey("image_id")) {
      Object obj = map.get("image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageId((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_status")) {
      Object obj = map.get("warning_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_status")) {
      Object obj = map.get("exception_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_remark")) {
      Object obj = map.get("check_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_task_id")) {
      Object obj = map.get("check_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_request_time")) {
      Object obj = map.get("check_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCheckRequestTime(null);
      }
    }
    if(map.containsKey("check_response_time")) {
      Object obj = map.get("check_response_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCheckResponseTime(null);
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_hooked")) {
      Object obj = map.get("is_hooked");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsHooked((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("x_point")) {
      Object obj = map.get("x_point");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setXPoint((Long)obj);
        } else if(obj instanceof String) {
          entity.setXPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setXPoint(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("y_point")) {
      Object obj = map.get("y_point");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setYPoint((Long)obj);
        } else if(obj instanceof String) {
          entity.setYPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setYPoint(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("width")) {
      Object obj = map.get("width");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWidth((Long)obj);
        } else if(obj instanceof String) {
          entity.setWidth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setWidth(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("height")) {
      Object obj = map.get("height");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHeight((Long)obj);
        } else if(obj instanceof String) {
          entity.setHeight(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setHeight(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("angle")) {
      Object obj = map.get("angle");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAngle((Long)obj);
        } else if(obj instanceof String) {
          entity.setAngle(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAngle(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ticket_code")) {
      Object obj = map.get("ticket_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPublic((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext_fields")) {
      Object obj = map.get("ext_fields");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtFields((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_reuse")) {
      Object obj = map.get("is_reuse");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsReuse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_status")) {
      Object obj = map.get("ticket_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_repeat")) {
      Object obj = map.get("is_repeat");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsRepeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("repeat_tag")) {
      Object obj = map.get("repeat_tag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRepeatTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_entity_code")) {
      Object obj = map.get("bill_entity_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillEntityCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reuse_tag")) {
      Object obj = map.get("reuse_tag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReuseTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_status")) {
      Object obj = map.get("back_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_time")) {
      Object obj = map.get("back_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBackTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBackTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBackTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setBackTime(null);
      }
    }
    if(map.containsKey("scan_user_id")) {
      Object obj = map.get("scan_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setScanUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setScanUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("scan_user_name")) {
      Object obj = map.get("scan_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_sales_list")) {
      Object obj = map.get("is_sales_list");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsSalesList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCalculateStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_check_status")) {
      Object obj = map.get("ticket_check_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handle_status")) {
      Object obj = map.get("handle_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commit_status")) {
      Object obj = map.get("commit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommitStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommitUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCommitTime(null);
      }
    }
    if(map.containsKey("hook_time")) {
      Object obj = map.get("hook_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHookTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setHookTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setHookTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setHookTime(null);
      }
    }
    if(map.containsKey("back_type")) {
      Object obj = map.get("back_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_reason")) {
      Object obj = map.get("back_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_remark")) {
      Object obj = map.get("back_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_user")) {
      Object obj = map.get("back_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_date")) {
      Object obj = map.get("invoice_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUploadStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_code")) {
      Object obj = map.get("purchaser_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scan_time")) {
      Object obj = map.get("scan_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setScanTime(null);
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_sheet")) {
      Object obj = map.get("invoice_sheet");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceSheet((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recheck")) {
      Object obj = map.get("recheck");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("drawer")) {
      Object obj = map.get("drawer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDrawer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_replace")) {
      Object obj = map.get("is_replace");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsReplace((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNameAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("production_area")) {
      Object obj = map.get("production_area");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductionArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("engine_no")) {
      Object obj = map.get("engine_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEngineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commodity_inspection_no")) {
      Object obj = map.get("commodity_inspection_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommodityInspectionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("certification_no")) {
      Object obj = map.get("certification_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCertificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_certificate_no")) {
      Object obj = map.get("import_certificate_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImportCertificateNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_tax_authority_code")) {
      Object obj = map.get("charge_tax_authority_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeTaxAuthorityCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_tax_authority_name")) {
      Object obj = map.get("charge_tax_authority_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeTaxAuthorityName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPaidProof((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTonnage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaxCapacity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dq_code")) {
      Object obj = map.get("dq_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDqCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dq_name")) {
      Object obj = map.get("dq_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDqName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_electric_invoice")) {
      Object obj = map.get("is_electric_invoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsElectricInvoice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_source_file")) {
      Object obj = map.get("is_source_file");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsSourceFile((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source_file_type")) {
      Object obj = map.get("source_file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSourceFileType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency_type")) {
      Object obj = map.get("currency_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrencyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("is_join")) {
      Object obj = map.get("is_join");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsJoin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qrcode")) {
      Object obj = map.get("qrcode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQrcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code_p")) {
      Object obj = map.get("invoice_code_p");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCodeP((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no_p")) {
      Object obj = map.get("invoice_no_p");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNoP((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_initial_value")) {
      Object obj = map.get("ticket_initial_value");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketInitialValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_change")) {
      Object obj = map.get("is_change");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsChange((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_change_value")) {
      Object obj = map.get("ticket_change_value");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketChangeValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("person_remark")) {
      Object obj = map.get("person_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPersonRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_add")) {
      Object obj = map.get("is_add");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsAdd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_stamper")) {
      Object obj = map.get("is_stamper");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsStamper((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_exist_sheet")) {
      Object obj = map.get("is_exist_sheet");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsExistSheet((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_key")) {
      Object obj = map.get("exception_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_detail")) {
      Object obj = map.get("exception_detail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_key")) {
      Object obj = map.get("warning_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_detail")) {
      Object obj = map.get("warning_detail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_sign_status")) {
      Object obj = map.get("check_sign_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckSignStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_sign_remark")) {
      Object obj = map.get("check_sign_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckSignRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_sign_task_id")) {
      Object obj = map.get("check_sign_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckSignTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_sign_request_time")) {
      Object obj = map.get("check_sign_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckSignRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckSignRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckSignRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCheckSignRequestTime(null);
      }
    }
    if(map.containsKey("check_sign_user_id")) {
      Object obj = map.get("check_sign_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckSignUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCheckSignUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCheckSignUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("check_sign_user_name")) {
      Object obj = map.get("check_sign_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckSignUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setChargeUpPeriod(null);
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_amount")) {
      Object obj = map.get("charge_up_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeUpAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeUpAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeUpAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setChargeUpAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeUpAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_amount")) {
      Object obj = map.get("payment_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("used_amount")) {
      Object obj = map.get("used_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUsedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUsedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUsedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUsedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUsedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("balance_amount")) {
      Object obj = map.get("balance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBalanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBalanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBalanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBalanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBalanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_person")) {
      Object obj = map.get("charge_up_person");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpPerson((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_user_name")) {
      Object obj = map.get("payment_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_original_ticket")) {
      Object obj = map.get("is_original_ticket");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsOriginalTicket((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_key")) {
      Object obj = map.get("business_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignForStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("all_system_labels")) {
      Object obj = map.get("all_system_labels");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAllSystemLabels((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("is_collection")) {
      Object obj = map.get("is_collection");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCollection((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_back_status")) {
      Object obj = map.get("audit_back_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditBackStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_solution")) {
      Object obj = map.get("check_solution");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckSolution((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("area_id")) {
      Object obj = map.get("area_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAreaId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAreaId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAreaId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("area_code")) {
      Object obj = map.get("area_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAreaCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("area_name")) {
      Object obj = map.get("area_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAreaName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("root_region")) {
      Object obj = map.get("root_region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRootRegion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("custom_region")) {
      Object obj = map.get("custom_region");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomRegion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reimbursement_status")) {
      Object obj = map.get("reimbursement_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReimbursementStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trains")) {
      Object obj = map.get("trains");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTrains((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_station")) {
      Object obj = map.get("start_station");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStartStation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("end_station")) {
      Object obj = map.get("end_station");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEndStation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_date")) {
      Object obj = map.get("start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("start_time")) {
      Object obj = map.get("start_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seat")) {
      Object obj = map.get("seat");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seat_type")) {
      Object obj = map.get("seat_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSeatType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("certificate_no")) {
      Object obj = map.get("certificate_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCertificateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
