package com.xforceplus.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.imagesaas.entity.BaseBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-06-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TravelExpenseBill extends BaseBill {


  /**
   * 出差人
   */
  private String businessUser;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("business_user", businessUser);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static TravelExpenseBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TravelExpenseBill entity = new TravelExpenseBill();
    if(map.containsKey("image_id")) {
      Object obj = map.get("image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageId((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_amount_with_tax")) {
      Object obj = map.get("bill_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bill_tax_amount")) {
      Object obj = map.get("bill_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bill_amount_without_tax")) {
      Object obj = map.get("bill_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bill_create_user")) {
      Object obj = map.get("bill_create_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCreateUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_create_time")) {
      Object obj = map.get("bill_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setBillCreateTime(null);
      }
    }
    if(map.containsKey("scan_user_id")) {
      Object obj = map.get("scan_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setScanUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setScanUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("scan_user_name")) {
      Object obj = map.get("scan_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scan_create_time")) {
      Object obj = map.get("scan_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setScanCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setScanCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setScanCreateTime(null);
      }
    }
    if(map.containsKey("package_code")) {
      Object obj = map.get("package_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPackageCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_status")) {
      Object obj = map.get("logistics_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticsStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_time")) {
      Object obj = map.get("logistics_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLogisticsTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLogisticsTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setLogisticsTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setLogisticsTime(null);
      }
    }
    if(map.containsKey("sign_status")) {
      Object obj = map.get("sign_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setSignTime(null);
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPublic((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_type")) {
      Object obj = map.get("hang_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_reason")) {
      Object obj = map.get("hang_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_type")) {
      Object obj = map.get("back_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_reason")) {
      Object obj = map.get("back_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_data_status")) {
      Object obj = map.get("bill_data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_data_time")) {
      Object obj = map.get("bill_data_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillDataTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillDataTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillDataTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setBillDataTime(null);
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setVerifyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setVerifyTime(null);
      }
    }
    if(map.containsKey("ticket_count")) {
      Object obj = map.get("ticket_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTicketCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setTicketCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTicketCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("image_count")) {
      Object obj = map.get("image_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("exception_count")) {
      Object obj = map.get("exception_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExceptionCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setExceptionCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setExceptionCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("warning_count")) {
      Object obj = map.get("warning_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarningCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setWarningCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setWarningCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_exception")) {
      Object obj = map.get("is_exception");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsException((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_secret")) {
      Object obj = map.get("is_secret");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsSecret((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_remark")) {
      Object obj = map.get("back_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unquality_type")) {
      Object obj = map.get("unquality_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnqualityType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unquality_reason")) {
      Object obj = map.get("unquality_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnqualityReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_hang_type")) {
      Object obj = map.get("verify_hang_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyHangType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_hang_reason")) {
      Object obj = map.get("verify_hang_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyHangReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_prepayment")) {
      Object obj = map.get("is_prepayment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPrepayment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext_fields")) {
      Object obj = map.get("ext_fields");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtFields((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext_status")) {
      Object obj = map.get("ext_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prepayment_status")) {
      Object obj = map.get("prepayment_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prepayment_time")) {
      Object obj = map.get("prepayment_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPrepaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPrepaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPrepaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setPrepaymentTime(null);
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_check_status")) {
      Object obj = map.get("bill_check_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_code")) {
      Object obj = map.get("purchaser_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_check_time")) {
      Object obj = map.get("bill_check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setBillCheckTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_orig")) {
      Object obj = map.get("back_orig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCalculateStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_warning")) {
      Object obj = map.get("is_warning");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsWarning((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_user")) {
      Object obj = map.get("back_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_commit")) {
      Object obj = map.get("is_commit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCommit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommitUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCommitTime(null);
      }
    }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUploadStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_push_bill")) {
      Object obj = map.get("is_push_bill");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPushBill((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCover((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_add")) {
      Object obj = map.get("is_add");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsAdd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_change")) {
      Object obj = map.get("is_change");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsChange((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_use")) {
      Object obj = map.get("bill_use");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillUse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_orig_external")) {
      Object obj = map.get("system_orig_external");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrigExternal((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("compare_status")) {
      Object obj = map.get("compare_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompareStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("complete_time")) {
      Object obj = map.get("complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCompleteTime(null);
      }
    }
    if(map.containsKey("settlement_type")) {
      Object obj = map.get("settlement_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_exception")) {
      Object obj = map.get("ticket_exception");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketException((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_warning")) {
      Object obj = map.get("ticket_warning");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketWarning((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_user")) {
      Object obj = map.get("business_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
