package com.xforceplus.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 报销状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-21
 */
public enum ReimbursementStatus {

    _0("0", "未报销"),
    _1("1", "报销中"),
    _2("2", "报销成功"),
    __1("-1", "报销失败"),
    _6("6", "部分报销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReimbursementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReimbursementStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "-1":
                return __1;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
