package com.xforceplus.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 转换场景
 * </p>
 *
 * @author ultraman
 * @since 2023-09-07
 */
public enum TransformScene {

    TRANS_REC("trans_rec", "转换并识别"),
    TRANS_NOT_REC("trans_not_rec", "转换不识别"),
    TRANS_LONG_IMG("trans_long_img", "转长图"),
    TRANS_ANT_ELEC("trans_ant_elec", "协同电票转换");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TransformScene(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransformScene fromCode(String code){
        switch(code) {
            case "trans_rec":
                return TRANS_REC;
            case "trans_not_rec":
                return TRANS_NOT_REC;
            case "trans_long_img":
                return TRANS_LONG_IMG;
            case "trans_ant_elec":
                return TRANS_ANT_ELEC;
            default:
                return null;
        }
    }
}
