package com.xforceplus.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据检测ICON
 * </p>
 *
 * @author ultraman
 * @since 2023-10-18
 */
public enum BillCheckIcons {

    COMPARE_COUNT_CHECK("compare_count_check", "张");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillCheckIcons(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillCheckIcons fromCode(String code){
        switch(code) {
            case "compare_count_check":
                return COMPARE_COUNT_CHECK;
            default:
                return null;
        }
    }
}
