package com.xforceplus.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 检测结果类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-18
 */
public enum CheckType {

    EXCEPTION("exception", "异常"),
    WARNING("warning", "预警");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CheckType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckType fromCode(String code){
        switch(code) {
            case "exception":
                return EXCEPTION;
            case "warning":
                return WARNING;
            default:
                return null;
        }
    }
}
