package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.BillException;
import com.xforceplus.imagesaas.service.IBillExceptionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class BillExceptionController {

  @Autowired
  private IBillExceptionService billExceptionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billException ${table.comment}
   * @return
   */
  @GetMapping("/billexceptions" )
  public XfR getBillExceptions(XfPage page, BillException billException) {
    return XfR.ok(billExceptionServiceImpl.page(page, Wrappers.query(billException)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billexceptions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billExceptionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billException ${table.comment}
   * @return XfR
   */
  @PostMapping("/billexceptions")
  public XfR save(@RequestBody BillException billException) {
     return XfR.ok(billExceptionServiceImpl.save(billException));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billException ${table.comment}
   * @return XfR
   */
  @PutMapping("/billexceptions/{id}")
  public XfR putUpdate(@RequestBody BillException billException,@PathVariable Long id) {
      billException.setId(id);
      return XfR.ok(billExceptionServiceImpl.updateById(billException));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billException ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billexceptions/{id}")
  public XfR patchUpdate(@RequestBody BillException billException,@PathVariable Long id) {
      BillException upbillException = billExceptionServiceImpl.getById(id);
      if(upbillException != null){
        upbillException = ObjectCopyUtils.copyProperties(billException,upbillException,true);
      }
      return XfR.ok(billExceptionServiceImpl.updateById(upbillException));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billexceptions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billExceptionServiceImpl.removeById(id));
  }

  @PostMapping("/billexceptions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_exception");
     params.put("request", condition);

     return XfR.ok(billExceptionServiceImpl.querys(params));
  }

}
