package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.BillWarning;
import com.xforceplus.imagesaas.service.IBillWarningService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class BillWarningController {

  @Autowired
  private IBillWarningService billWarningServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billWarning ${table.comment}
   * @return
   */
  @GetMapping("/billwarnings" )
  public XfR getBillWarnings(XfPage page, BillWarning billWarning) {
    return XfR.ok(billWarningServiceImpl.page(page, Wrappers.query(billWarning)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billwarnings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billWarningServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billWarning ${table.comment}
   * @return XfR
   */
  @PostMapping("/billwarnings")
  public XfR save(@RequestBody BillWarning billWarning) {
     return XfR.ok(billWarningServiceImpl.save(billWarning));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billWarning ${table.comment}
   * @return XfR
   */
  @PutMapping("/billwarnings/{id}")
  public XfR putUpdate(@RequestBody BillWarning billWarning,@PathVariable Long id) {
      billWarning.setId(id);
      return XfR.ok(billWarningServiceImpl.updateById(billWarning));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billWarning ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billwarnings/{id}")
  public XfR patchUpdate(@RequestBody BillWarning billWarning,@PathVariable Long id) {
      BillWarning upbillWarning = billWarningServiceImpl.getById(id);
      if(upbillWarning != null){
        upbillWarning = ObjectCopyUtils.copyProperties(billWarning,upbillWarning,true);
      }
      return XfR.ok(billWarningServiceImpl.updateById(upbillWarning));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billwarnings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billWarningServiceImpl.removeById(id));
  }

  @PostMapping("/billwarnings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_warning");
     params.put("request", condition);

     return XfR.ok(billWarningServiceImpl.querys(params));
  }

}
