package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareAccountBill;
import com.xforceplus.imagesaas.service.ICompareAccountBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareAccountBillController {

  @Autowired
  private ICompareAccountBillService compareAccountBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareAccountBill ${table.comment}
   * @return
   */
  @GetMapping("/compareaccountbills" )
  public XfR getCompareAccountBills(XfPage page, CompareAccountBill compareAccountBill) {
    return XfR.ok(compareAccountBillServiceImpl.page(page, Wrappers.query(compareAccountBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareaccountbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareAccountBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareAccountBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareaccountbills")
  public XfR save(@RequestBody CompareAccountBill compareAccountBill) {
     return XfR.ok(compareAccountBillServiceImpl.save(compareAccountBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareAccountBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareaccountbills/{id}")
  public XfR putUpdate(@RequestBody CompareAccountBill compareAccountBill,@PathVariable Long id) {
      compareAccountBill.setId(id);
      return XfR.ok(compareAccountBillServiceImpl.updateById(compareAccountBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareAccountBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareaccountbills/{id}")
  public XfR patchUpdate(@RequestBody CompareAccountBill compareAccountBill,@PathVariable Long id) {
      CompareAccountBill upcompareAccountBill = compareAccountBillServiceImpl.getById(id);
      if(upcompareAccountBill != null){
        upcompareAccountBill = ObjectCopyUtils.copyProperties(compareAccountBill,upcompareAccountBill,true);
      }
      return XfR.ok(compareAccountBillServiceImpl.updateById(upcompareAccountBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareaccountbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareAccountBillServiceImpl.removeById(id));
  }

  @PostMapping("/compareaccountbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_account_bill");
     params.put("request", condition);

     return XfR.ok(compareAccountBillServiceImpl.querys(params));
  }

}
