package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.ComparePurchaseBill;
import com.xforceplus.imagesaas.service.IComparePurchaseBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class ComparePurchaseBillController {

  @Autowired
  private IComparePurchaseBillService comparePurchaseBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param comparePurchaseBill ${table.comment}
   * @return
   */
  @GetMapping("/comparepurchasebills" )
  public XfR getComparePurchaseBills(XfPage page, ComparePurchaseBill comparePurchaseBill) {
    return XfR.ok(comparePurchaseBillServiceImpl.page(page, Wrappers.query(comparePurchaseBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparepurchasebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(comparePurchaseBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param comparePurchaseBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/comparepurchasebills")
  public XfR save(@RequestBody ComparePurchaseBill comparePurchaseBill) {
     return XfR.ok(comparePurchaseBillServiceImpl.save(comparePurchaseBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param comparePurchaseBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/comparepurchasebills/{id}")
  public XfR putUpdate(@RequestBody ComparePurchaseBill comparePurchaseBill,@PathVariable Long id) {
      comparePurchaseBill.setId(id);
      return XfR.ok(comparePurchaseBillServiceImpl.updateById(comparePurchaseBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param comparePurchaseBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/comparepurchasebills/{id}")
  public XfR patchUpdate(@RequestBody ComparePurchaseBill comparePurchaseBill,@PathVariable Long id) {
      ComparePurchaseBill upcomparePurchaseBill = comparePurchaseBillServiceImpl.getById(id);
      if(upcomparePurchaseBill != null){
        upcomparePurchaseBill = ObjectCopyUtils.copyProperties(comparePurchaseBill,upcomparePurchaseBill,true);
      }
      return XfR.ok(comparePurchaseBillServiceImpl.updateById(upcomparePurchaseBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparepurchasebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(comparePurchaseBillServiceImpl.removeById(id));
  }

  @PostMapping("/comparepurchasebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_purchase_bill");
     params.put("request", condition);

     return XfR.ok(comparePurchaseBillServiceImpl.querys(params));
  }

}
