package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareSalesBill;
import com.xforceplus.imagesaas.service.ICompareSalesBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareSalesBillController {

  @Autowired
  private ICompareSalesBillService compareSalesBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareSalesBill ${table.comment}
   * @return
   */
  @GetMapping("/comparesalesbills" )
  public XfR getCompareSalesBills(XfPage page, CompareSalesBill compareSalesBill) {
    return XfR.ok(compareSalesBillServiceImpl.page(page, Wrappers.query(compareSalesBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparesalesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareSalesBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareSalesBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/comparesalesbills")
  public XfR save(@RequestBody CompareSalesBill compareSalesBill) {
     return XfR.ok(compareSalesBillServiceImpl.save(compareSalesBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareSalesBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/comparesalesbills/{id}")
  public XfR putUpdate(@RequestBody CompareSalesBill compareSalesBill,@PathVariable Long id) {
      compareSalesBill.setId(id);
      return XfR.ok(compareSalesBillServiceImpl.updateById(compareSalesBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareSalesBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/comparesalesbills/{id}")
  public XfR patchUpdate(@RequestBody CompareSalesBill compareSalesBill,@PathVariable Long id) {
      CompareSalesBill upcompareSalesBill = compareSalesBillServiceImpl.getById(id);
      if(upcompareSalesBill != null){
        upcompareSalesBill = ObjectCopyUtils.copyProperties(compareSalesBill,upcompareSalesBill,true);
      }
      return XfR.ok(compareSalesBillServiceImpl.updateById(upcompareSalesBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparesalesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareSalesBillServiceImpl.removeById(id));
  }

  @PostMapping("/comparesalesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_sales_bill");
     params.put("request", condition);

     return XfR.ok(compareSalesBillServiceImpl.querys(params));
  }

}
