package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketAttachment;
import com.xforceplus.imagesaas.service.ICompareTicketAttachmentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketAttachmentController {

  @Autowired
  private ICompareTicketAttachmentService compareTicketAttachmentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketAttachment ${table.comment}
   * @return
   */
  @GetMapping("/compareticketattachments" )
  public XfR getCompareTicketAttachments(XfPage page, CompareTicketAttachment compareTicketAttachment) {
    return XfR.ok(compareTicketAttachmentServiceImpl.page(page, Wrappers.query(compareTicketAttachment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketattachments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketAttachmentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketAttachment ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketattachments")
  public XfR save(@RequestBody CompareTicketAttachment compareTicketAttachment) {
     return XfR.ok(compareTicketAttachmentServiceImpl.save(compareTicketAttachment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketAttachment ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketattachments/{id}")
  public XfR putUpdate(@RequestBody CompareTicketAttachment compareTicketAttachment,@PathVariable Long id) {
      compareTicketAttachment.setId(id);
      return XfR.ok(compareTicketAttachmentServiceImpl.updateById(compareTicketAttachment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketAttachment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketattachments/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketAttachment compareTicketAttachment,@PathVariable Long id) {
      CompareTicketAttachment upcompareTicketAttachment = compareTicketAttachmentServiceImpl.getById(id);
      if(upcompareTicketAttachment != null){
        upcompareTicketAttachment = ObjectCopyUtils.copyProperties(compareTicketAttachment,upcompareTicketAttachment,true);
      }
      return XfR.ok(compareTicketAttachmentServiceImpl.updateById(upcompareTicketAttachment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketattachments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketAttachmentServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketattachments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_attachment");
     params.put("request", condition);

     return XfR.ok(compareTicketAttachmentServiceImpl.querys(params));
  }

}
