package com.xforceplus.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.imagesaas.entity.CompareTicketBus;
import com.xforceplus.imagesaas.service.ICompareTicketBusService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-07
 */
@RestController
public class CompareTicketBusController {

  @Autowired
  private ICompareTicketBusService compareTicketBusServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketBus ${table.comment}
   * @return
   */
  @GetMapping("/compareticketbuss" )
  public XfR getCompareTicketBuss(XfPage page, CompareTicketBus compareTicketBus) {
    return XfR.ok(compareTicketBusServiceImpl.page(page, Wrappers.query(compareTicketBus)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketbuss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketBusServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareTicketBus ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareticketbuss")
  public XfR save(@RequestBody CompareTicketBus compareTicketBus) {
     return XfR.ok(compareTicketBusServiceImpl.save(compareTicketBus));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareTicketBus ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareticketbuss/{id}")
  public XfR putUpdate(@RequestBody CompareTicketBus compareTicketBus,@PathVariable Long id) {
      compareTicketBus.setId(id);
      return XfR.ok(compareTicketBusServiceImpl.updateById(compareTicketBus));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareTicketBus ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareticketbuss/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketBus compareTicketBus,@PathVariable Long id) {
      CompareTicketBus upcompareTicketBus = compareTicketBusServiceImpl.getById(id);
      if(upcompareTicketBus != null){
        upcompareTicketBus = ObjectCopyUtils.copyProperties(compareTicketBus,upcompareTicketBus,true);
      }
      return XfR.ok(compareTicketBusServiceImpl.updateById(upcompareTicketBus));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketbuss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketBusServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketbuss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_bus");
     params.put("request", condition);

     return XfR.ok(compareTicketBusServiceImpl.querys(params));
  }

}
